/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.graph;

import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiLongInterval;
import org.teamapps.ux.component.timegraph.GraphChangeListener;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.model.GraphModel;

public abstract class AbstractGraph<D extends GraphData, M extends GraphModel<D>> {
    private final String id = UUID.randomUUID().toString();
    protected GraphChangeListener changeListener;
    private M model;
    private Interval displayedIntervalY;
    private ScaleType yScaleType = ScaleType.LINEAR;
    private LineChartYScaleZoomMode yScaleZoomMode = LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
    private boolean yZeroLineVisible = false;
    private boolean yAxisVisible = true;
    private Color yAxisColor = RgbaColor.BLACK;

    public AbstractGraph(M model) {
        this.model = model;
    }

    public String getId() {
        return this.id;
    }

    public abstract UiGraph createUiFormat();

    public Interval getDisplayedIntervalY() {
        return this.displayedIntervalY;
    }

    public AbstractGraph setDisplayedIntervalY(Interval displayedIntervalY) {
        this.displayedIntervalY = displayedIntervalY;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public ScaleType getYScaleType() {
        return this.yScaleType;
    }

    public AbstractGraph setYScaleType(ScaleType yScaleType) {
        this.yScaleType = yScaleType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public LineChartYScaleZoomMode getYScaleZoomMode() {
        return this.yScaleZoomMode;
    }

    public AbstractGraph setYScaleZoomMode(LineChartYScaleZoomMode yScaleZoomMode) {
        this.yScaleZoomMode = yScaleZoomMode;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public void setChangeListener(GraphChangeListener listener) {
        this.changeListener = listener;
    }

    protected void mapAbstractLineChartDataDisplayProperties(UiGraph ui) {
        ui.setId(this.id);
        ui.setYAxisVisible(this.yAxisVisible);
        ui.setYAxisColor(this.yAxisColor != null ? this.yAxisColor.toHtmlColorString() : null);
        ui.setIntervalY(this.displayedIntervalY != null ? this.displayedIntervalY.toUiLongInterval() : new UiLongInterval(0L, 1000L));
        ui.setYScaleType(this.yScaleType.toUiScaleType());
        ui.setYScaleZoomMode(this.yScaleZoomMode.toUiLineChartYScaleZoomMode());
        ui.setYZeroLineVisible(this.yZeroLineVisible);
    }

    public boolean isYZeroLineVisible() {
        return this.yZeroLineVisible;
    }

    public AbstractGraph setYZeroLineVisible(boolean yZeroLineVisible) {
        this.yZeroLineVisible = yZeroLineVisible;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public boolean isyAxisVisible() {
        return this.yAxisVisible;
    }

    public AbstractGraph setYAxisVisible(boolean yAxisVisible) {
        this.yAxisVisible = yAxisVisible;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getYAxisColor() {
        return this.yAxisColor;
    }

    public AbstractGraph setYAxisColor(Color yAxisColor) {
        this.yAxisColor = yAxisColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public M getModel() {
        return this.model;
    }

    public AbstractGraph<D, M> setModel(M model) {
        this.model = model;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }
}

