/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.graph;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiGraphGroup;
import org.teamapps.ux.component.timegraph.GraphChangeListener;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.datapoints.GraphGroupData;
import org.teamapps.ux.component.timegraph.graph.AbstractGraph;
import org.teamapps.ux.component.timegraph.model.AbstractGraphGroupModel;

public class GraphGroup
extends AbstractGraph<GraphGroupData, org.teamapps.ux.component.timegraph.model.GraphGroupModel> {
    private GraphChangeListener changeListener;
    private final List<AbstractGraph<?, ?>> graphs = new ArrayList();

    public GraphGroup(AbstractGraph<?, ?> ... graphs) {
        this(Arrays.asList(graphs));
    }

    public GraphGroup(List<AbstractGraph<?, ?>> graphs) {
        super(null);
        this.setModel(new GraphGroupModel());
        this.graphs.addAll(graphs);
        graphs.forEach(dd -> {
            if (this.changeListener != null) {
                this.changeListener.handleChange(this);
            }
        });
    }

    public UiGraphGroup createUiFormat() {
        UiGraphGroup ui = new UiGraphGroup();
        this.mapAbstractLineChartDataDisplayProperties((UiGraph)ui);
        ui.setGraphs(this.graphs.stream().map(AbstractGraph::createUiFormat).collect(Collectors.toList()));
        return ui;
    }

    @Override
    public void setChangeListener(GraphChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public GraphGroupModel getModel() {
        return (GraphGroupModel)super.getModel();
    }

    public void addGraph(AbstractGraph<?, ?> graph) {
        this.graphs.add(graph);
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        this.getModel().onDataChanged.fire();
    }

    public void removeGraph(AbstractGraph<?, ?> graph) {
        this.graphs.remove(graph);
        this.getModel().onDataChanged.fire();
    }

    public List<AbstractGraph<?, ?>> getGraphs() {
        return List.copyOf(this.graphs);
    }

    private class GraphGroupModel
    extends AbstractGraphGroupModel {
        private GraphGroupModel() {
        }

        @Override
        public Interval getDomainX() {
            return GraphGroup.this.graphs.stream().map(g -> g.getModel().getDomainX()).reduce(Interval::union).orElse(new Interval(0L, 1L));
        }

        @Override
        public GraphGroupData getData(TimePartitioning zoomLevel, ZoneId zoneId, Interval neededInterval, Interval displayedInterval) {
            Map<String, GraphData> graphDataByGraphId = GraphGroup.this.graphs.stream().collect(Collectors.toMap(AbstractGraph::getId, g -> g.getModel().getData(zoomLevel, zoneId, neededInterval, displayedInterval)));
            return () -> graphDataByGraphId;
        }
    }
}

