/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.graph;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiGraph;
import org.teamapps.dto.UiLineGraph;
import org.teamapps.ux.component.timegraph.GraphChangeListener;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;
import org.teamapps.ux.component.timegraph.graph.AbstractGraph;
import org.teamapps.ux.component.timegraph.model.LineGraphModel;

public class LineGraph
extends AbstractGraph<LineGraphData, LineGraphModel> {
    private LineChartCurveType graphType;
    private float dataDotRadius;
    private Color lineColorScaleMin;
    private Color lineColorScaleMax;
    private Color areaColorScaleMin;
    private Color areaColorScaleMax;

    public LineGraph(LineGraphModel model) {
        this(model, LineChartCurveType.MONOTONE, 2.0f, (Color)new RgbaColor(73, 128, 192));
    }

    public LineGraph(LineGraphModel model, LineChartCurveType graphType, float dataDotRadius, Color lineColor) {
        this(model, graphType, dataDotRadius, lineColor, lineColor, null, null);
    }

    public LineGraph(LineGraphModel model, LineChartCurveType graphType, float dataDotRadius, Color lineColor, Color areaColor) {
        this(model, graphType, dataDotRadius, lineColor, lineColor, (Color)(areaColor instanceof RgbaColor ? ((RgbaColor)areaColor).withAlpha(0.0f) : null), areaColor);
    }

    public LineGraph(LineGraphModel model, LineChartCurveType graphType, float dataDotRadius, Color lineColorScaleMin, Color lineColorScaleMax, Color areaColorScaleMin, Color areaColorScaleMax) {
        super(model);
        this.graphType = graphType;
        this.dataDotRadius = dataDotRadius;
        this.lineColorScaleMin = lineColorScaleMin;
        this.lineColorScaleMax = lineColorScaleMax;
        this.areaColorScaleMin = areaColorScaleMin;
        this.areaColorScaleMax = areaColorScaleMax;
    }

    public UiLineGraph createUiFormat() {
        UiLineGraph ui = new UiLineGraph();
        this.mapAbstractLineChartDataDisplayProperties((UiGraph)ui);
        ui.setGraphType(this.graphType.toUiLineChartCurveType());
        ui.setDataDotRadius(this.dataDotRadius);
        ui.setLineColorScaleMin(this.lineColorScaleMin != null ? this.lineColorScaleMin.toHtmlColorString() : null);
        ui.setLineColorScaleMax(this.lineColorScaleMax != null ? this.lineColorScaleMax.toHtmlColorString() : null);
        ui.setAreaColorScaleMin(this.areaColorScaleMin != null ? this.areaColorScaleMin.toHtmlColorString() : null);
        ui.setAreaColorScaleMax(this.areaColorScaleMax != null ? this.areaColorScaleMax.toHtmlColorString() : null);
        return ui;
    }

    public LineChartCurveType getGraphType() {
        return this.graphType;
    }

    public LineGraph setGraphType(LineChartCurveType graphType) {
        this.graphType = graphType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public LineGraph setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLineColorScaleMin() {
        return this.lineColorScaleMin;
    }

    public LineGraph setLineColorScaleMin(Color lineColorScaleMin) {
        this.lineColorScaleMin = lineColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLineColorScaleMax() {
        return this.lineColorScaleMax;
    }

    public LineGraph setLineColorScaleMax(Color lineColorScaleMax) {
        this.lineColorScaleMax = lineColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColorScaleMin() {
        return this.areaColorScaleMin;
    }

    public LineGraph setAreaColorScaleMin(Color areaColorScaleMin) {
        this.areaColorScaleMin = areaColorScaleMin;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColorScaleMax() {
        return this.areaColorScaleMax;
    }

    public LineGraph setAreaColorScaleMax(Color areaColorScaleMax) {
        this.areaColorScaleMax = areaColorScaleMax;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    @Override
    public void setChangeListener(GraphChangeListener listener) {
        this.changeListener = listener;
    }
}

