/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.data.value.Sorting;
import org.teamapps.ux.application.model.PerspectiveDataModel;
import org.teamapps.ux.component.calendar.AbstractCalendarModel;
import org.teamapps.ux.component.calendar.CalendarEvent;
import org.teamapps.ux.component.calendar.CalendarModel;
import org.teamapps.ux.component.infiniteitemview.AbstractInfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.table.TableModel;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.AbstractRawTimedDataModel;
import org.teamapps.ux.component.timegraph.partitioning.PartitioningTimeGraphModel;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoExtractor;
import org.teamapps.ux.model.AbstractTreeModel;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.session.CurrentSessionContext;

public abstract class AbstractPerspectiveDataModel<RECORD>
implements PerspectiveDataModel<RECORD> {
    private final PropertyProvider<RECORD> propertyProvider;
    private AbstractTableModel<RECORD> tableModel;
    private AbstractInfiniteItemViewModel<RECORD> infiniteItemViewModel;
    private AbstractCalendarModel<RECORD> calendarModel;
    private Function<RECORD, CalendarEvent<RECORD>> calendarEventProvider;
    private TimeGraphModel timeGraphModel;
    private TreeModel<RECORD> treeModel;

    public AbstractPerspectiveDataModel(PropertyProvider<RECORD> propertyProvider) {
        this.propertyProvider = propertyProvider;
        this.init();
    }

    public abstract int getRecordCount();

    public abstract List<RECORD> getEntities(int var1, int var2, Instant var3, Instant var4, Sorting var5);

    private void init() {
        this.tableModel = new AbstractTableModel<RECORD>(){

            @Override
            public int getCount() {
                return AbstractPerspectiveDataModel.this.getRecordCount();
            }

            @Override
            public List<RECORD> getRecords(int startIndex, int length, Sorting sorting) {
                return AbstractPerspectiveDataModel.this.getEntities(startIndex, length, null, null, sorting);
            }
        };
        this.infiniteItemViewModel = new AbstractInfiniteItemViewModel<RECORD>(){

            @Override
            public int getCount() {
                return AbstractPerspectiveDataModel.this.getRecordCount();
            }

            @Override
            public List<RECORD> getRecords(int startIndex, int length) {
                return AbstractPerspectiveDataModel.this.getEntities(startIndex, length, null, null, null);
            }
        };
        this.calendarModel = new AbstractCalendarModel<RECORD>(){

            @Override
            public List<CalendarEvent<RECORD>> getEventsForInterval(Instant start, Instant end) {
                if (AbstractPerspectiveDataModel.this.calendarEventProvider == null) {
                    return Collections.emptyList();
                }
                List entities = AbstractPerspectiveDataModel.this.getEntities(0, Integer.MAX_VALUE, start, end, null);
                return entities.stream().map(RECORD -> (CalendarEvent)AbstractPerspectiveDataModel.this.calendarEventProvider.apply(RECORD)).collect(Collectors.toList());
            }
        };
        this.timeGraphModel = new PartitioningTimeGraphModel(CurrentSessionContext.get().getTimeZone(), new AbstractRawTimedDataModel(){

            @Override
            public Map<String, long[]> getRawEventTimes(Collection<String> lineIds, Interval neededIntervalX) {
                return AbstractPerspectiveDataModel.this.getTimeGraphData(lineIds, neededIntervalX);
            }

            @Override
            public Interval getDomainX(Collection<String> lineIds) {
                return AbstractPerspectiveDataModel.this.getTimeGraphDomain(lineIds);
            }
        });
        this.treeModel = new AbstractTreeModel<RECORD>(){

            @Override
            public List<RECORD> getRecords(String query) {
                return AbstractPerspectiveDataModel.this.getEntities(0, Integer.MAX_VALUE, null, null, null);
            }
        };
    }

    protected void handleDataUpdated() {
        this.tableModel.onAllDataChanged.fire(null);
        this.infiniteItemViewModel.onAllDataChanged.fire(null);
        this.calendarModel.onCalendarDataChanged.fire(null);
        this.timeGraphModel.onDataChanged().fire(null);
        this.treeModel.onAllNodesChanged().fire(null);
    }

    private Map<String, long[]> getTimeGraphData(Collection<String> lineIds, Interval interval) {
        long startTime = interval.getMin();
        long endTime = interval.getMax();
        HashMap<String, long[]> timeStampsByLineId = new HashMap<String, long[]>();
        List<RECORD> entities = this.getEntities(0, Integer.MAX_VALUE, null, null, null);
        for (String lineId : lineIds) {
            long[] timeStamps = new long[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                long time;
                Instant instant = this.propertyProvider.getInstantValue(entities.get(i), lineId);
                if (instant == null || startTime > (time = instant.toEpochMilli()) || endTime < time) continue;
                timeStamps[i] = time;
            }
            long[] filteredTimestamps = Arrays.stream(timeStamps).filter(value -> value > 0L).toArray();
            timeStampsByLineId.put(lineId, filteredTimestamps);
        }
        return timeStampsByLineId;
    }

    private Interval getTimeGraphDomain(Collection<String> lineIds) {
        List<RECORD> entities = this.getEntities(0, Integer.MAX_VALUE, null, null, null);
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        for (String lineId : lineIds) {
            for (int i = 0; i < entities.size(); ++i) {
                Instant instant = this.propertyProvider.getInstantValue(entities.get(i), lineId);
                if (instant == null) continue;
                long time = instant.toEpochMilli();
                minValue = Math.min(minValue, time);
                maxValue = Math.max(maxValue, time);
            }
        }
        return new Interval(minValue, maxValue);
    }

    public PropertyProvider<RECORD> getPropertyProvider() {
        return this.propertyProvider;
    }

    @Override
    public TableModel<RECORD> getTableModel() {
        return this.tableModel;
    }

    @Override
    public InfiniteItemViewModel<RECORD> getInfiniteItemViewModel() {
        return this.infiniteItemViewModel;
    }

    @Override
    public TimeGraphModel getTimeGraphModel() {
        return this.timeGraphModel;
    }

    @Override
    public TreeModel<RECORD> getTreeModel() {
        return this.treeModel;
    }

    public AbstractCalendarModel<RECORD> getCalendarModel() {
        return this.calendarModel;
    }

    @Override
    public TreeNodeInfoExtractor<RECORD> getTreeNodeParentExtractor(final String parentPropertyName) {
        if (parentPropertyName == null) {
            return null;
        }
        return record -> new TreeNodeInfo(){

            @Override
            public Object getParent() {
                return AbstractPerspectiveDataModel.this.propertyProvider.getValue(record, parentPropertyName);
            }

            @Override
            public boolean isLazyChildren() {
                return false;
            }

            @Override
            public boolean isExpanded() {
                return false;
            }
        };
    }

    @Override
    public CalendarModel<RECORD> getCalendarModel(Function<RECORD, CalendarEvent<RECORD>> eventProvider, String calendarFieldName) {
        if (eventProvider != null) {
            this.calendarEventProvider = eventProvider;
        }
        return this.calendarModel;
    }
}

