/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiCheckBox;
import org.teamapps.dto.UiField;
import org.teamapps.util.UiUtil;
import org.teamapps.ux.component.field.AbstractField;

public class CheckBox
extends AbstractField<Boolean> {
    private String caption;
    private Color backgroundColor = new Color(255, 255, 255);
    private Color checkColor = new Color(70, 70, 70);
    private Color borderColor = new Color(204, 204, 204);

    public CheckBox(String caption) {
        this.caption = caption;
    }

    public CheckBox() {
        this(null);
    }

    public UiField createUiComponent() {
        UiCheckBox uiCheckBox = new UiCheckBox(this.getId());
        this.mapAbstractFieldAttributesToUiField((UiField)uiCheckBox);
        uiCheckBox.setCaption(this.caption);
        uiCheckBox.setBackgroundColor(this.backgroundColor != null ? UiUtil.createUiColor(this.backgroundColor) : null);
        uiCheckBox.setCheckColor(this.checkColor != null ? UiUtil.createUiColor(this.checkColor) : null);
        uiCheckBox.setBorderColor(this.borderColor != null ? UiUtil.createUiColor(this.borderColor) : null);
        return uiCheckBox;
    }

    @Override
    protected void doDestroy() {
    }

    public String getCaption() {
        return this.caption;
    }

    public CheckBox setCaption(String caption) {
        this.caption = caption;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetCaptionCommand(this.getId(), caption));
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public CheckBox setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetBackgroundColorCommand(this.getId(), backgroundColor != null ? UiUtil.createUiColor(backgroundColor) : null));
        return this;
    }

    public Color getCheckColor() {
        return this.checkColor;
    }

    public CheckBox setCheckColor(Color checkColor) {
        this.checkColor = checkColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetCheckColorCommand(this.getId(), checkColor != null ? UiUtil.createUiColor(checkColor) : null));
        return this;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public CheckBox setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.queueCommandIfRendered(() -> new UiCheckBox.SetBorderColorCommand(this.getId(), borderColor != null ? UiUtil.createUiColor(borderColor) : null));
        return this;
    }
}

