/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import java.time.Instant;
import org.teamapps.dto.AbstractUiDateField;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiInstantDateField;
import org.teamapps.ux.component.field.datetime.AbstractDateField;

public class InstantDateField
extends AbstractDateField<InstantDateField, Instant> {
    private String timeZoneId = null;

    public UiField createUiComponent() {
        UiInstantDateField dateField = new UiInstantDateField(this.getId());
        this.mapAbstractDateFieldUiValues((AbstractUiDateField)dateField);
        dateField.setTimeZoneId(this.timeZoneId);
        return dateField;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        this.queueCommandIfRendered(() -> new UiInstantDateField.SetTimeZoneIdCommand(this.getId(), timeZoneId));
    }

    @Override
    public Instant convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(((Number)value).longValue());
    }
}

