/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.ClassAndPropertyName;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.util.ReflectionUtil;

public class BeanPropertyInjector<RECORD>
implements PropertyInjector<RECORD> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanPropertyInjector.class);
    private static final Map<ClassAndPropertyName, ValueInjector> settersByClassAndPropertyName = new ConcurrentHashMap<ClassAndPropertyName, ValueInjector>();
    private final Map<String, ValueInjector> customInjectors = new HashMap<String, ValueInjector>(0);
    private final boolean fallbackToFields;

    public BeanPropertyInjector() {
        this(false);
    }

    public BeanPropertyInjector(boolean fallbackToFields) {
        this.fallbackToFields = fallbackToFields;
    }

    @Override
    public void setValue(RECORD record, String propertyName, Object value) {
        ValueInjector valueInjector = this.getValueInjector(record.getClass(), propertyName);
        valueInjector.inject(record, value);
    }

    private ValueInjector getValueInjector(Class clazz, String propertyName) {
        ValueInjector ValueInjector2 = this.customInjectors.get(propertyName);
        if (ValueInjector2 != null) {
            return ValueInjector2;
        }
        return settersByClassAndPropertyName.computeIfAbsent(new ClassAndPropertyName(clazz, propertyName, this.fallbackToFields), classAndPropertyName -> this.createValueInjector((ClassAndPropertyName)classAndPropertyName));
    }

    private ValueInjector<RECORD, ?> createValueInjector(ClassAndPropertyName classAndPropertyName) {
        Field field;
        Method setter = ReflectionUtil.findSetter(classAndPropertyName.clazz, classAndPropertyName.propertyName);
        if (setter != null) {
            return (record, value) -> ReflectionUtil.invokeMethod(record, setter, value);
        }
        if (this.fallbackToFields && (field = ReflectionUtil.findField(classAndPropertyName.clazz, classAndPropertyName.propertyName)) != null && !Modifier.isFinal(field.getModifiers())) {
            return (record, value) -> ReflectionUtil.setField(record, field, value, true);
        }
        LOGGER.debug("Could not find setter or field for property {} on class {}!", (Object)classAndPropertyName.propertyName, (Object)classAndPropertyName.getClass().getCanonicalName());
        return (record, value) -> {};
    }

    public <VALUE> BeanPropertyInjector<RECORD> addProperty(String propertyName, ValueInjector<RECORD, VALUE> valueInjector) {
        this.customInjectors.put(propertyName, valueInjector);
        return this;
    }
}

