/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.session.CurrentSessionContext;

public final class Fields {
    private Fields() {
    }

    public static boolean validateAll(AbstractField<?> ... fields) {
        return Fields.validateAll(Arrays.stream(fields));
    }

    public static boolean validateAll(List<AbstractField<?>> fields) {
        return Fields.validateAll(fields.stream());
    }

    public static boolean validateAll(Stream<AbstractField<?>> stream) {
        List errorMessage = stream.flatMap(field -> field.validate().stream()).filter(message -> message.getSeverity() == FieldMessage.Severity.ERROR).collect(Collectors.toList());
        return errorMessage.size() == 0;
    }

    public static boolean validateAllAsRequired(AbstractField<?> ... fields) {
        FieldMessage errorMessage = new FieldMessage(FieldMessage.Severity.ERROR, CurrentSessionContext.get().getLocalized(TeamAppsDictionary.REQUIRED_FIELD.getKey(), new Object[0]));
        boolean isNotEmpty = true;
        for (AbstractField<?> field : fields) {
            if (!field.isEmpty()) continue;
            field.removeCustomFieldMessage(errorMessage);
            field.addCustomFieldMessage(errorMessage);
            isNotEmpty = false;
        }
        return isNotEmpty;
    }
}

