/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload.simple;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiSimpleFileField;
import org.teamapps.event.Event;
import org.teamapps.formatter.FileSizeFormatter;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.upload.FileFieldDisplayType;
import org.teamapps.ux.component.field.upload.simple.FileItem;
import org.teamapps.ux.component.field.upload.simple.FileItemState;
import org.teamapps.ux.i18n.TeamAppsDictionary;

public class SimpleFileField
extends AbstractField<List<FileItem>> {
    public final Event<FileItem> onUploadInitiatedByUser = new Event();
    public final Event<FileItem> onUploadTooLarge = new Event();
    public final Event<FileItem> onUploadStarted = new Event();
    public final Event<FileItem> onUploadCanceledByUser = new Event();
    public final Event<FileItem> onUploadFailed = new Event();
    public final Event<FileItem> onUploadSuccessful = new Event();
    public final Event<FileItem> onFileItemClicked = new Event();
    public final Event<FileItem> onFileItemRemoved = new Event();
    private final List<FileItem> fileItems = new ArrayList<FileItem>();
    private FileFieldDisplayType displayType = FileFieldDisplayType.FLOATING;
    private int maxFiles = Integer.MAX_VALUE;
    private long maxBytesPerFile = 10000000L;
    private String uploadUrl = "/upload";
    private Icon browseButtonIcon = MaterialIcon.FILE_UPLOAD;
    private final Icon defaultItemIcon = MaterialIcon.CARD_TRAVEL;
    private String browseButtonCaption = this.getSessionContext().getLocalized(TeamAppsDictionary.UPLOAD.getKey(), new Object[0]);

    public void addFileItem(FileItem fileItem) {
        fileItem.setState(FileItemState.DONE);
        this.fileItems.add(fileItem);
        fileItem.setFileField(this);
        this.queueCommandIfRendered(() -> new UiSimpleFileField.AddFileItemCommand(this.getId(), fileItem.createUiFileItem()));
    }

    public void removeFileItem(FileItem fileItem) {
        this.removeFileItemInternal(fileItem);
        this.queueCommandIfRendered(() -> new UiSimpleFileField.RemoveFileItemCommand(this.getId(), fileItem.getUuid()));
    }

    private void removeFileItemInternal(FileItem fileItem) {
        this.fileItems.remove(fileItem);
        fileItem.setFileField(null);
    }

    void handleFileItemChanged(FileItem fileItem) {
        this.queueCommandIfRendered(() -> new UiSimpleFileField.UpdateFileItemCommand(this.getId(), fileItem.createUiFileItem()));
    }

    private FileItem getFileItemByUuid(String uuid) {
        return this.fileItems.stream().filter(item -> item.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    @Override
    public List<FileItem> convertUiValueToUxValue(Object value) {
        return this.fileItems;
    }

    @Override
    public List<FileItem> getValue() {
        return this.fileItems;
    }

    @Override
    public boolean isEmpty() {
        return this.fileItems.isEmpty();
    }

    @Override
    public UiComponent createUiComponent() {
        UiSimpleFileField field = new UiSimpleFileField();
        this.mapAbstractFieldAttributesToUiField((UiField)field);
        field.setBrowseButtonIcon(this.getSessionContext().resolveIcon(this.browseButtonIcon));
        field.setBrowseButtonCaption(this.browseButtonCaption);
        field.setUploadUrl(this.uploadUrl);
        field.setMaxBytesPerFile(this.maxBytesPerFile);
        field.setFileTooLargeMessage(this.getSessionContext().getLocalized(TeamAppsDictionary.FILE_TOO_LARGE_SHORT_MESSAGE.getKey(), FileSizeFormatter.humanReadableByteCount(this.maxBytesPerFile, true, 1)));
        field.setUploadErrorMessage(this.getSessionContext().getLocalized(TeamAppsDictionary.UPLOAD_ERROR_MESSAGE.getKey(), new Object[0]));
        field.setMaxFiles(this.maxFiles);
        field.setDisplayMode(this.displayType.toUiFileFieldDisplayType());
        field.setFileItems(this.fileItems.stream().map(fi -> fi.createUiFileItem()).collect(Collectors.toList()));
        return field;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_SIMPLE_FILE_FIELD_UPLOAD_INITIATED_BY_USER: {
                UiSimpleFileField.UploadInitiatedByUserEvent initEvent = (UiSimpleFileField.UploadInitiatedByUserEvent)event;
                FileItem fileItem = new FileItem(initEvent.getUuid(), initEvent.getFileName(), FileItemState.INITIATING, initEvent.getMimeType(), initEvent.getSizeInBytes());
                fileItem.setFileField(this);
                this.fileItems.add(fileItem);
                this.onUploadInitiatedByUser.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_UPLOAD_TOO_LARGE: {
                UiSimpleFileField.UploadTooLargeEvent tooLargeEvent = (UiSimpleFileField.UploadTooLargeEvent)event;
                FileItem fileItem = this.getFileItemByUuid(tooLargeEvent.getFileItemUuid());
                if (fileItem == null) break;
                fileItem.setState(FileItemState.TOO_LARGE);
                this.onUploadTooLarge.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_UPLOAD_STARTED: {
                UiSimpleFileField.UploadStartedEvent startedEvent = (UiSimpleFileField.UploadStartedEvent)event;
                FileItem fileItem = this.getFileItemByUuid(startedEvent.getFileItemUuid());
                if (fileItem == null) break;
                fileItem.setState(FileItemState.UPLOADING);
                this.onUploadStarted.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_UPLOAD_CANCELED: {
                UiSimpleFileField.UploadCanceledEvent startedEvent = (UiSimpleFileField.UploadCanceledEvent)event;
                FileItem fileItem = this.getFileItemByUuid(startedEvent.getFileItemUuid());
                if (fileItem == null) break;
                fileItem.setState(FileItemState.CANCELED);
                this.onUploadCanceledByUser.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_UPLOAD_FAILED: {
                UiSimpleFileField.UploadFailedEvent startedEvent = (UiSimpleFileField.UploadFailedEvent)event;
                FileItem fileItem = this.getFileItemByUuid(startedEvent.getFileItemUuid());
                if (fileItem == null) break;
                fileItem.setState(FileItemState.FAILED);
                this.onUploadFailed.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_UPLOAD_SUCCESSFUL: {
                UiSimpleFileField.UploadSuccessfulEvent successEvent = (UiSimpleFileField.UploadSuccessfulEvent)event;
                FileItem fileItem = this.getFileItemByUuid(successEvent.getFileItemUuid());
                if (fileItem == null) break;
                fileItem.setState(FileItemState.DONE);
                fileItem.setIcon(this.defaultItemIcon);
                File uploadedFile = this.getSessionContext().getUploadedFileByUuid(successEvent.getUploadedFileUuid());
                if (uploadedFile != null) {
                    fileItem.setLinkUrl(this.getSessionContext().createFileLink(uploadedFile));
                    fileItem.setFile(uploadedFile);
                }
                this.onUploadSuccessful.fire(fileItem);
                this.onValueChanged.fire(this.getValue());
                break;
            }
            case UI_SIMPLE_FILE_FIELD_FILE_ITEM_CLICKED: {
                UiSimpleFileField.FileItemClickedEvent clickEvent = (UiSimpleFileField.FileItemClickedEvent)event;
                FileItem fileItem = this.getFileItemByUuid(clickEvent.getFileItemUuid());
                if (fileItem == null) break;
                this.onFileItemClicked.fire(fileItem);
                break;
            }
            case UI_SIMPLE_FILE_FIELD_FILE_ITEM_REMOVED: {
                UiSimpleFileField.FileItemRemovedEvent removedEvent = (UiSimpleFileField.FileItemRemovedEvent)event;
                FileItem fileItem = this.getFileItemByUuid(removedEvent.getFileItemUuid());
                if (fileItem == null) break;
                this.removeFileItemInternal(fileItem);
                this.onFileItemRemoved.fire(fileItem);
                break;
            }
        }
    }

    public FileFieldDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(FileFieldDisplayType displayType) {
        this.displayType = displayType;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetDisplayModeCommand(this.getId(), displayType.toUiFileFieldDisplayType()));
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetMaxFilesCommand(this.getId(), maxFiles));
    }

    public long getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    public void setMaxBytesPerFile(long maxBytesPerFile) {
        this.maxBytesPerFile = maxBytesPerFile;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetMaxBytesPerFileCommand(this.getId(), maxBytesPerFile));
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetFileTooLargeMessageCommand(this.getId(), this.getSessionContext().getLocalized(TeamAppsDictionary.FILE_TOO_LARGE_SHORT_MESSAGE.getKey(), FileSizeFormatter.humanReadableByteCount(maxBytesPerFile, true, 1))));
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetUploadUrlCommand(this.getId(), uploadUrl));
    }

    public Icon getBrowseButtonIcon() {
        return this.browseButtonIcon;
    }

    public void setBrowseButtonIcon(Icon browseButtonIcon) {
        this.browseButtonIcon = browseButtonIcon;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetBrowseButtonIconCommand(this.getId(), this.getSessionContext().resolveIcon(browseButtonIcon)));
    }

    public String getBrowseButtonCaption() {
        return this.browseButtonCaption;
    }

    public void setBrowseButtonCaption(String browseButtonCaption) {
        this.browseButtonCaption = browseButtonCaption;
        this.queueCommandIfRendered(() -> new UiSimpleFileField.SetBrowseButtonCaptionCommand(this.getId(), browseButtonCaption));
    }
}

