/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiNotificationBarItem;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.animation.EntranceAnimation;
import org.teamapps.ux.component.animation.ExitAnimation;
import org.teamapps.ux.component.animation.RepeatableAnimation;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.notification.NotificationBarItemClosedEvent;
import org.teamapps.ux.session.SessionContext;

public class NotificationBarItem {
    public final Event<Void> onClicked = new Event();
    public final Event<NotificationBarItemClosedEvent.ClosingReason> onClosed = new Event();
    private final String uiId = UUID.randomUUID().toString();
    private final Icon icon;
    private final String text;
    private final RepeatableAnimation iconAnimation;
    private final boolean dismissible;
    private final int displayTimeInMillis;
    private final boolean progressBarVisible;
    private final Color backgroundColor;
    private final Color borderColor;
    private final Color textColor;
    private final Spacing padding;
    private final EntranceAnimation entranceAnimation;
    private final ExitAnimation exitAnimation;

    public NotificationBarItem(Icon icon, String text) {
        this(icon, text, true);
    }

    public NotificationBarItem(Icon icon, String text, boolean dismissible) {
        this(icon, text, dismissible, 0, false);
    }

    public NotificationBarItem(Icon icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible) {
        this(icon, text, dismissible, displayTimeInMillis, progressBarVisible, null, null, null, null, null);
    }

    public NotificationBarItem(Icon icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible, Color backgroundColor, Color borderColor, Color textColor, Spacing padding, RepeatableAnimation iconAnimation) {
        this(icon, text, dismissible, displayTimeInMillis, progressBarVisible, backgroundColor, borderColor, textColor, padding, iconAnimation, EntranceAnimation.FADE_IN_DOWN, ExitAnimation.FADE_OUT_UP);
    }

    public NotificationBarItem(Icon icon, String text, boolean dismissible, int displayTimeInMillis, boolean progressBarVisible, Color backgroundColor, Color borderColor, Color textColor, Spacing padding, RepeatableAnimation iconAnimation, EntranceAnimation entranceAnimation, ExitAnimation exitAnimation) {
        this.icon = icon;
        this.text = text;
        this.dismissible = dismissible;
        this.displayTimeInMillis = displayTimeInMillis;
        this.progressBarVisible = progressBarVisible;
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.textColor = textColor;
        this.padding = padding;
        this.iconAnimation = iconAnimation;
        this.entranceAnimation = entranceAnimation;
        this.exitAnimation = exitAnimation;
    }

    public UiNotificationBarItem toUiNotificationBarItem() {
        UiNotificationBarItem ui = new UiNotificationBarItem();
        ui.setId(this.uiId);
        ui.setIcon(SessionContext.current().resolveIcon(this.icon));
        ui.setIconAnimation(this.iconAnimation != null ? this.iconAnimation.toUiRepeatableAnimation() : null);
        ui.setText(this.text);
        ui.setDismissible(this.dismissible);
        ui.setDisplayTimeInMillis(this.displayTimeInMillis);
        ui.setProgressBarVisible(this.progressBarVisible);
        ui.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        ui.setBorderColor(this.borderColor != null ? this.borderColor.toHtmlColorString() : null);
        ui.setTextColor(this.textColor != null ? this.textColor.toHtmlColorString() : null);
        ui.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        return ui;
    }

    public String getUiId() {
        return this.uiId;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText() {
        return this.text;
    }

    public boolean isDismissible() {
        return this.dismissible;
    }

    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    public boolean isProgressBarVisible() {
        return this.progressBarVisible;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public RepeatableAnimation getIconAnimation() {
        return this.iconAnimation;
    }
}

