/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiToolbarButtonGroup;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.AbstractToolContainer;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroupPosition;

public class ToolbarButtonGroup
implements Comparable<ToolbarButtonGroup> {
    private AbstractToolContainer toolContainer;
    private String clientId = UUID.randomUUID().toString();
    private final List<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
    private ToolbarButtonGroupPosition position;
    private boolean rightSide;
    private boolean visible = true;
    private boolean showGroupSeparator = true;
    private Template buttonTemplate;
    private PropertyProvider propertyProvider;

    public ToolbarButtonGroup() {
        this(new ArrayList<ToolbarButton>(), ToolbarButtonGroupPosition.CENTER);
    }

    public ToolbarButtonGroup(ToolbarButtonGroupPosition position) {
        this(new ArrayList<ToolbarButton>(), position);
    }

    public ToolbarButtonGroup(List<ToolbarButton> buttons, ToolbarButtonGroupPosition position) {
        buttons.forEach(this::addButton);
        this.position = position;
    }

    public void setToolContainer(AbstractToolContainer toolContainer) {
        this.toolContainer = toolContainer;
    }

    public void setButtons(List<ToolbarButton> buttons) {
        new ArrayList<ToolbarButton>(this.buttons).forEach(button -> this.removeButton((ToolbarButton)button));
        buttons.forEach(button -> this.addButton((ToolbarButton)button));
    }

    public ToolbarButton addButton(ToolbarButton button) {
        return this.addButton(button, null, false);
    }

    public ToolbarButton addButton(ToolbarButton button, ToolbarButton neighborButton, boolean beforeNeighbor) {
        this.buttons.add(button);
        button.setToolbarButtonGroup(this);
        if (this.toolContainer != null) {
            this.toolContainer.handleAddButton(this, button, neighborButton != null ? neighborButton.getClientId() : null, beforeNeighbor);
        }
        return button;
    }

    public void removeButton(ToolbarButton button) {
        this.buttons.remove(button);
        button.setToolbarButtonGroup(null);
        if (this.toolContainer != null) {
            this.toolContainer.handleButtonRemoved(this, button);
        }
    }

    protected String getClientId() {
        return this.clientId;
    }

    public List<ToolbarButton> getButtons() {
        return this.buttons;
    }

    public ToolbarButtonGroupPosition getPosition() {
        return this.position;
    }

    public UiToolbarButtonGroup createUiToolbarButtonGroup() {
        List buttons = this.buttons.stream().map(button -> button.createUiToolbarButton()).collect(Collectors.toList());
        UiToolbarButtonGroup buttonGroup = new UiToolbarButtonGroup(this.clientId, buttons);
        buttonGroup.setVisible(this.visible);
        buttonGroup.setShowGroupSeparator(this.showGroupSeparator);
        return buttonGroup;
    }

    public AbstractToolContainer getToolContainer() {
        return this.toolContainer;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        if (oldValue != visible && this.toolContainer != null) {
            this.toolContainer.handleGroupVisibilityChange(this.clientId, visible);
        }
    }

    public boolean isShowGroupSeparator() {
        return this.showGroupSeparator;
    }

    public void setShowGroupSeparator(boolean showGroupSeparator) {
        this.showGroupSeparator = showGroupSeparator;
    }

    public void setPosition(ToolbarButtonGroupPosition position) {
        this.position = position;
    }

    @Override
    public int compareTo(ToolbarButtonGroup o) {
        return this.position.compareTo(o.getPosition());
    }

    void handleButtonVisibilityChange(String buttonClientId, boolean visible) {
        if (this.toolContainer != null) {
            this.toolContainer.handleButtonVisibilityChange(this.clientId, buttonClientId, visible);
        }
    }

    void handleDropDownComponentUpdate(ToolbarButton button, Component component) {
        if (this.toolContainer != null) {
            this.toolContainer.handleButtonSetDropDownComponent(this, button, component);
        }
    }

    public void handleColorChange(String buttonClientId, Color backgroundColor, Color hoverBackgroundColor) {
        if (this.toolContainer != null) {
            this.toolContainer.handleButtonColorChange(this.clientId, buttonClientId, backgroundColor, hoverBackgroundColor);
        }
    }

    public Template getButtonTemplate() {
        return this.buttonTemplate;
    }

    public void setButtonTemplate(Template buttonTemplate) {
        this.buttonTemplate = buttonTemplate;
    }

    public Template getAppliedTemplate() {
        return this.buttonTemplate != null ? this.buttonTemplate : this.toolContainer.getButtonTemplate();
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public void setPropertyProvider(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.setPropertyProvider(propertyExtractor);
    }

    public PropertyProvider getAppliedPropertyProvider() {
        return this.propertyProvider != null ? this.propertyProvider : this.toolContainer.getPropertyProvider();
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isRightSide() {
        return this.rightSide;
    }

    public void setRightSide(boolean rightSide) {
        this.rightSide = rightSide;
    }
}

