/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.datapoints;

import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.teamapps.dto.UiLineGraphData;
import org.teamapps.dto.UiLineGraphDataPoint;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphDataPoint;

public interface LineGraphData
extends GraphData {
    public int size();

    public double getX(int var1);

    public double getY(int var1);

    public LineGraphDataPoint getDataPoint(int var1);

    default public DoubleStream streamX() {
        int[] i = new int[]{0};
        return DoubleStream.generate(() -> {
            int n = i[0];
            i[0] = n + 1;
            return this.getX(n);
        }).limit(this.size());
    }

    default public DoubleStream streamY() {
        int[] i = new int[]{0};
        return DoubleStream.generate(() -> {
            int n = i[0];
            i[0] = n + 1;
            return this.getX(n);
        }).limit(this.size());
    }

    default public Stream<LineGraphDataPoint> streamDataPoints() {
        int[] i = new int[]{0};
        return Stream.generate(() -> {
            int n = i[0];
            i[0] = n + 1;
            return this.getDataPoint(n);
        }).limit(this.size());
    }

    default public UiLineGraphData toUiGraphData() {
        return new UiLineGraphData(this.streamDataPoints().map(dp -> new UiLineGraphDataPoint(dp.getX(), dp.getY())).collect(Collectors.toList()), this.getInterval().toUiLongInterval());
    }
}

