/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;

public class ClientSessionResourceProvider {
    public static final String BASE_PATH = "/files/";
    private QualifiedUiSessionId sessionId;
    private AtomicInteger idGenerator = new AtomicInteger();
    private Map<Integer, Resource> binaryResourceById = new HashMap<Integer, Resource>();
    private Map<File, String> fileLinkByFile = new HashMap<File, String>();
    private Map<String, String> resourceLinkByUniqueIdentifier = new HashMap<String, String>();

    public ClientSessionResourceProvider(QualifiedUiSessionId sessionId) {
        this.sessionId = sessionId;
    }

    public Resource getBinaryResource(int resourceId) {
        return this.binaryResourceById.get(resourceId);
    }

    public String createFileLink(File file) {
        if (file == null) {
            return null;
        }
        if (this.fileLinkByFile.containsKey(file)) {
            return this.fileLinkByFile.get(file);
        }
        FileResource resource = new FileResource(file);
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String fileLink = this.createLink(id);
        this.fileLinkByFile.put(file, fileLink);
        return fileLink;
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        if (resource == null) {
            return null;
        }
        if (uniqueIdentifier != null && this.resourceLinkByUniqueIdentifier.containsKey(uniqueIdentifier)) {
            return this.resourceLinkByUniqueIdentifier.get(uniqueIdentifier);
        }
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String resourceLink = this.createLink(id);
        if (uniqueIdentifier != null) {
            this.resourceLinkByUniqueIdentifier.put(uniqueIdentifier, resourceLink);
        }
        return resourceLink;
    }

    private int createId() {
        return this.idGenerator.incrementAndGet();
    }

    private String createLink(int id) {
        return BASE_PATH + this.sessionId.getUiSessionId() + "/res" + id;
    }
}

