/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.databinding;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.NonRecursiveEventListenerBuilder;
import org.teamapps.databinding.ObservableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;

public final class DataBindings {
    public static <T> ObservableValue<T> createObservableValueWithEmptyEvent(final Event<?> changeEvent, final Supplier<T> provider) {
        return new ObservableValue<T>(){

            @Override
            public Event<T> onChanged() {
                Event eventWithData = new Event();
                changeEvent.addListener(o -> eventWithData.fire(this.get()));
                return eventWithData;
            }

            @Override
            public T get() {
                return provider.get();
            }
        };
    }

    public static <T> ObservableValue<T> createObservableValue(final Event<T> changeEvent, final Supplier<T> provider) {
        return new ObservableValue<T>(){

            @Override
            public Event<T> onChanged() {
                return changeEvent;
            }

            @Override
            public T get() {
                return provider.get();
            }
        };
    }

    public static <T> ObservableValue<T> createObservableValue(final Event<T> changeEvent) {
        return new ObservableValue<T>(){
            private T lastSeenValue;
            {
                changeEvent.addListener(t -> {
                    this.lastSeenValue = t;
                });
            }

            @Override
            public Event<T> onChanged() {
                return changeEvent;
            }

            @Override
            public T get() {
                return this.lastSeenValue;
            }
        };
    }

    public static <T> MutableValue<T> createMutableValue(Consumer<T> consumer) {
        return consumer::accept;
    }

    public static <T> TwoWayBindableValue<T> createTwoWayBindable(final Event<T> changeEvent, final Supplier<T> supplier, final Consumer<T> consumer) {
        return new TwoWayBindableValue<T>(){

            @Override
            public Event<T> onChanged() {
                return changeEvent;
            }

            @Override
            public T get() {
                return supplier.get();
            }

            @Override
            public void set(T value) {
                consumer.accept(value);
            }
        };
    }

    public static <T> TwoWayBindableValue<T> createTwoWayBindable(final Event<T> changeEvent, final Consumer<T> consumer) {
        return new TwoWayBindableValue<T>(){
            private T lastSeenValue;
            {
                changeEvent.addListener(t -> {
                    this.lastSeenValue = t;
                });
            }

            @Override
            public Event<T> onChanged() {
                return changeEvent;
            }

            @Override
            public T get() {
                return this.lastSeenValue;
            }

            @Override
            public void set(T value) {
                consumer.accept(value);
            }
        };
    }

    public static <T> void bindOneWay(ObservableValue<T> observableValue, MutableValue<T> mutableValue) {
        mutableValue.set(observableValue.get());
        observableValue.onChanged().addListener(value -> mutableValue.set(observableValue.get()));
    }

    public static <T> void bindTwoWays(TwoWayBindableValue<T> bindable1, TwoWayBindableValue<T> bindable2) {
        NonRecursiveEventListenerBuilder nonRecursiveEventListenerBuilder = new NonRecursiveEventListenerBuilder();
        bindable1.onChanged().addListener(nonRecursiveEventListenerBuilder.create(aVoid -> bindable2.set(bindable1.get())));
        bindable2.onChanged().addListener(nonRecursiveEventListenerBuilder.create(aVoid -> bindable1.set(bindable2.get())));
        bindable2.set(bindable1.get());
    }
}

