/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util.threading;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.util.ExceptionUtil;
import org.teamapps.util.threading.MinMaxAverageStats;
import org.teamapps.util.threading.SequentialExecutorFactory;

public class CompletableFutureChainSequentialExecutorFactory
implements SequentialExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureChainSequentialExecutorFactory.class);
    private final AtomicReference<MinMaxAverageStats> delayStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final AtomicReference<MinMaxAverageStats> executionTimeStats = new AtomicReference<MinMaxAverageStats>(new MinMaxAverageStats());
    private final ExecutorService pool;

    public CompletableFutureChainSequentialExecutorFactory(int nThreads) {
        this(Executors.newFixedThreadPool(nThreads));
    }

    public CompletableFutureChainSequentialExecutorFactory(ExecutorService executorService) {
        this.pool = executorService;
        ScheduledExecutorService statsLogExecutorService = Executors.newSingleThreadScheduledExecutor();
        statsLogExecutorService.scheduleAtFixedRate(() -> {
            MinMaxAverageStats delayStats = this.delayStats.getAndSet(new MinMaxAverageStats());
            MinMaxAverageStats executionTimeStats = this.executionTimeStats.getAndSet(new MinMaxAverageStats());
            if (delayStats.getMax() > 3000L) {
                LOGGER.warn("Delays critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{delayStats.getMin(), delayStats.getMax(), delayStats.getAvg(), delayStats.getCount()});
            }
            if (executionTimeStats.getMax() > 1000L) {
                LOGGER.warn("Execution times critical: min: {}, max: {}, avg: {}, count: {}", new Object[]{executionTimeStats.getMin(), executionTimeStats.getMax(), executionTimeStats.getAvg(), executionTimeStats.getCount()});
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public ExecutorService createExecutor() {
        return new SequentialExecutor();
    }

    public static class SequentialExecutorClosedException
    extends RuntimeException {
    }

    public class SequentialExecutor
    extends AbstractExecutorService {
        private CompletableFuture<?> lastFuture = CompletableFuture.completedFuture(null);
        private final AtomicInteger queueSize = new AtomicInteger(0);
        private boolean closed = false;

        @Override
        public void execute(Runnable command) {
            this.submit(command);
        }

        public synchronized CompletableFuture<Void> submit(Runnable runnable) {
            return this.submit(() -> {
                runnable.run();
                return null;
            });
        }

        public synchronized <V> CompletableFuture<V> submit(Callable<V> task) {
            if (this.closed) {
                LOGGER.debug("SequentialExecutor already closed.");
                return CompletableFuture.failedFuture(new SequentialExecutorClosedException());
            }
            int queueSize = this.queueSize.incrementAndGet();
            LOGGER.debug("Queue size: {}", (Object)queueSize);
            if (queueSize >= 500 && queueSize % 10 == 0) {
                LOGGER.warn("Queue is very long: {}", (Object)queueSize);
            }
            long submitTime = System.currentTimeMillis();
            CompletionStage returnedFuture = this.lastFuture.thenApplyAsync(o -> {
                long executionStartTime = System.currentTimeMillis();
                long delay = executionStartTime - submitTime;
                CompletableFutureChainSequentialExecutorFactory.this.delayStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(delay));
                Object result = ExceptionUtil.softenExceptions((Callable)task);
                long executionTime = System.currentTimeMillis() - executionStartTime;
                CompletableFutureChainSequentialExecutorFactory.this.executionTimeStats.getAndUpdate(minMaxAverageStats -> minMaxAverageStats.push(executionTime));
                this.queueSize.decrementAndGet();
                return result;
            }, (Executor)CompletableFutureChainSequentialExecutorFactory.this.pool);
            this.lastFuture = ((CompletableFuture)returnedFuture).exceptionally(throwable -> {
                LOGGER.error("Error while executing: ", throwable);
                return null;
            });
            return returnedFuture;
        }

        @Override
        public void shutdown() {
            this.closed = true;
        }

        @Override
        public boolean isShutdown() {
            return this.closed;
        }

        @Override
        public boolean isTerminated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }
    }
}

