/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.upload;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFileField;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.event.Event;
import org.teamapps.formatter.FileSizeFormatter;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.upload.FileFieldDisplayType;
import org.teamapps.ux.component.field.upload.UploadCanceledEventData;
import org.teamapps.ux.component.field.upload.UploadFailedEventData;
import org.teamapps.ux.component.field.upload.UploadStartedEventData;
import org.teamapps.ux.component.field.upload.UploadSuccessfulEventData;
import org.teamapps.ux.component.field.upload.UploadTooLargeEventData;
import org.teamapps.ux.component.field.upload.UploadedFile;
import org.teamapps.ux.component.field.upload.UploadedFileAccessException;
import org.teamapps.ux.component.field.upload.UploadedFileToRecordConverter;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;

public class FileField<RECORD>
extends AbstractField<List<RECORD>> {
    public final Event<UploadTooLargeEventData> onUploadTooLarge = new Event();
    public final Event<UploadStartedEventData> onUploadStarted = new Event();
    public final Event<UploadCanceledEventData> onUploadCanceled = new Event();
    public final Event<UploadFailedEventData> onUploadFailed = new Event();
    public final Event<UploadSuccessfulEventData<RECORD>> onUploadSuccessful = new Event();
    public final Event<RECORD> onFileItemClicked = new Event();
    public final Event<RECORD> onFileItemRemoved = new Event();
    private FileFieldDisplayType displayType = FileFieldDisplayType.FLOATING;
    private boolean showEntriesAsButtonsOnHover = false;
    private int maxFiles = Integer.MAX_VALUE;
    private long maxBytesPerFile = 10000000L;
    private String uploadUrl = "/upload";
    private Template uploadButtonTemplate = BaseTemplate.BUTTON;
    private Object uploadButtonData = new BaseTemplateRecord(this.getSessionContext().getIcon(TeamAppsIconBundle.UPLOAD.getKey()), this.getSessionContext().getLocalized(TeamAppsDictionary.UPLOAD.getKey(), new Object[0]));
    private PropertyProvider uploadButtonPropertyProvider = new BeanPropertyExtractor();
    private final UploadedFileToRecordConverter<RECORD> uploadedFileToRecordConverter;
    private Template fileItemTemplate = BaseTemplate.FILE_ITEM_FLOATING;
    private PropertyProvider<RECORD> fileItemPropertyProvider = new BeanPropertyExtractor();
    private final ClientRecordCache<RECORD, UiIdentifiableClientRecord> recordCache = new ClientRecordCache<Object, UiIdentifiableClientRecord>(this::createUiIdentifiableClientRecord);

    public FileField(UploadedFileToRecordConverter<RECORD> uploadedFileToRecordConverter) {
        this.uploadedFileToRecordConverter = uploadedFileToRecordConverter;
    }

    public static FileField<BaseTemplateRecord<UploadedFile>> create() {
        return new FileField<BaseTemplateRecord<UploadedFile>>(file -> new BaseTemplateRecord<UploadedFile>((Icon)MaterialIcon.ATTACH_FILE, file.getName(), FileSizeFormatter.humanReadableByteCount(file.getSizeInBytes(), true, 1), file));
    }

    public UiField createUiComponent() {
        Map<String, Object> uploadButtonData = this.uploadButtonPropertyProvider.getValues(this.uploadButtonData, this.uploadButtonTemplate.getPropertyNames());
        UiFileField uiField = new UiFileField(this.fileItemTemplate.createUiTemplate(), this.uploadButtonTemplate.createUiTemplate(), uploadButtonData);
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setMaxBytesPerFile(this.maxBytesPerFile);
        uiField.setUploadUrl(this.uploadUrl);
        uiField.setFileTooLargeMessage(this.getSessionContext().getLocalized(TeamAppsDictionary.FILE_TOO_LARGE_SHORT_MESSAGE.getKey(), FileSizeFormatter.humanReadableByteCount(this.maxBytesPerFile, true, 1)));
        uiField.setUploadErrorMessage(this.getSessionContext().getLocalized(TeamAppsDictionary.UPLOAD_ERROR_MESSAGE.getKey(), new Object[0]));
        uiField.setDisplayType(this.displayType.toUiFileFieldDisplayType());
        uiField.setMaxFiles(this.maxFiles);
        uiField.setShowEntriesAsButtonsOnHover(this.showEntriesAsButtonsOnHover);
        return uiField;
    }

    @Override
    public void setValue(List<RECORD> records) {
        this.setValue(records, true);
    }

    public void setValue(List<RECORD> records, boolean cancelUploads) {
        if (cancelUploads) {
            this.cancelUploads();
        }
        super.setValue(records);
    }

    public void cancelUploads() {
        this.queueCommandIfRendered(() -> new UiFileField.CancelAllUploadsCommand(this.getId()));
    }

    private UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setValues(this.fileItemPropertyProvider.getValues(record, this.fileItemTemplate.getPropertyNames()));
        return clientRecord;
    }

    @Override
    public Object convertUxValueToUiValue(List<RECORD> uxValue) {
        if (uxValue == null) {
            return null;
        }
        CacheManipulationHandle<List<UiIdentifiableClientRecord>> cacheResponse = this.recordCache.replaceRecords(uxValue);
        cacheResponse.commit();
        return cacheResponse.getAndClearResult();
    }

    @Override
    public List<RECORD> convertUiValueToUxValue(Object uiValues) {
        if (uiValues == null) {
            return new ArrayList();
        }
        List clientIds = (List)uiValues;
        return clientIds.stream().map(clientId -> this.recordCache.getRecordByClientId((int)clientId)).collect(Collectors.toList());
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        super.handleUiEvent(event);
        switch (event.getUiEventType()) {
            case UI_FILE_FIELD_UPLOAD_TOO_LARGE: {
                UiFileField.UploadTooLargeEvent tooLargeEvent = (UiFileField.UploadTooLargeEvent)event;
                this.onUploadTooLarge.fire(new UploadTooLargeEventData(tooLargeEvent.getFileName(), tooLargeEvent.getMimeType(), tooLargeEvent.getSizeInBytes()));
                break;
            }
            case UI_FILE_FIELD_UPLOAD_STARTED: {
                UiFileField.UploadStartedEvent uploadStartedEvent = (UiFileField.UploadStartedEvent)event;
                this.onUploadStarted.fire(new UploadStartedEventData(uploadStartedEvent.getFileName(), uploadStartedEvent.getMimeType(), uploadStartedEvent.getSizeInBytes(), () -> this.queueCommandIfRendered(() -> new UiFileField.CancelUploadCommand(this.getId(), uploadStartedEvent.getFileItemUuid()))));
                break;
            }
            case UI_FILE_FIELD_UPLOAD_CANCELED: {
                UiFileField.UploadCanceledEvent canceledEvent = (UiFileField.UploadCanceledEvent)event;
                this.onUploadCanceled.fire(new UploadCanceledEventData(canceledEvent.getFileName(), canceledEvent.getMimeType(), canceledEvent.getSizeInBytes()));
                break;
            }
            case UI_FILE_FIELD_UPLOAD_FAILED: {
                UiFileField.UploadFailedEvent failedEvent = (UiFileField.UploadFailedEvent)event;
                this.onUploadFailed.fire(new UploadFailedEventData(failedEvent.getFileName(), failedEvent.getMimeType(), failedEvent.getSizeInBytes()));
                break;
            }
            case UI_FILE_FIELD_UPLOAD_SUCCESSFUL: {
                UiFileField.UploadSuccessfulEvent uploadedEvent = (UiFileField.UploadSuccessfulEvent)event;
                UploadedFile uploadedFile = new UploadedFile(uploadedEvent.getUploadedFileUuid(), uploadedEvent.getFileName(), uploadedEvent.getSizeInBytes(), uploadedEvent.getMimeType(), () -> {
                    try {
                        return new FileInputStream(this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                    }
                    catch (FileNotFoundException e) {
                        throw new UploadedFileAccessException(e);
                    }
                }, () -> this.getSessionContext().getUploadedFileByUuid(uploadedEvent.getUploadedFileUuid()));
                RECORD record = this.uploadedFileToRecordConverter.convert(uploadedFile);
                CacheManipulationHandle<UiIdentifiableClientRecord> cacheResponse = this.recordCache.addRecord(record);
                if (this.isRendered()) {
                    this.getSessionContext().queueCommand(new UiFileField.ReplaceFileItemCommand(this.getId(), uploadedEvent.getFileItemUuid(), cacheResponse.getAndClearResult()), aVoid -> cacheResponse.commit());
                } else {
                    cacheResponse.commit();
                }
                this.onUploadSuccessful.fire(new UploadSuccessfulEventData<RECORD>(uploadedFile, record));
                break;
            }
            case UI_FILE_FIELD_FILE_ITEM_CLICKED: {
                UiFileField.FileItemClickedEvent fileClickedEvent = (UiFileField.FileItemClickedEvent)event;
                RECORD record = this.recordCache.getRecordByClientId(fileClickedEvent.getClientId());
                this.onFileItemClicked.fire(record);
                break;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null || ((List)this.getValue()).isEmpty();
    }

    @Override
    protected void applyValueFromUi(Object value) {
        ArrayList<Object> oldValue = new ArrayList<Object>(this.getValue() != null ? (Collection)this.getValue() : Collections.emptyList());
        super.applyValueFromUi(value);
        if (oldValue != null) {
            oldValue.removeAll(this.getValue() != null ? (Collection)this.getValue() : Collections.emptyList());
            oldValue.forEach(record -> this.onFileItemRemoved.fire(record));
        }
    }

    public Template getFileItemTemplate() {
        return this.fileItemTemplate;
    }

    public void setFileItemTemplate(Template fileItemTemplate) {
        this.fileItemTemplate = fileItemTemplate;
        this.queueCommandIfRendered(() -> new UiFileField.SetItemTemplateCommand(this.getId(), fileItemTemplate.createUiTemplate()));
    }

    public long getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    public void setMaxBytesPerFile(long maxBytesPerFile) {
        this.maxBytesPerFile = maxBytesPerFile;
        this.queueCommandIfRendered(() -> new UiFileField.SetMaxBytesPerFileCommand(this.getId(), maxBytesPerFile));
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        this.queueCommandIfRendered(() -> new UiFileField.SetUploadUrlCommand(this.getId(), uploadUrl));
    }

    public Template getUploadButtonTemplate() {
        return this.uploadButtonTemplate;
    }

    public void setUploadButtonTemplate(Template uploadButtonTemplate) {
        this.uploadButtonTemplate = uploadButtonTemplate;
        this.queueCommandIfRendered(() -> new UiFileField.SetUploadButtonTemplateCommand(this.getId(), uploadButtonTemplate.createUiTemplate()));
    }

    public Object getUploadButtonData() {
        return this.uploadButtonData;
    }

    public void setUploadButtonData(Object uploadButtonData) {
        this.uploadButtonData = uploadButtonData;
        this.queueCommandIfRendered(() -> new UiFileField.SetUploadButtonDataCommand(this.getId(), uploadButtonData));
    }

    public boolean isShowEntriesAsButtonsOnHover() {
        return this.showEntriesAsButtonsOnHover;
    }

    public void setShowEntriesAsButtonsOnHover(boolean showEntriesAsButtonsOnHover) {
        this.showEntriesAsButtonsOnHover = showEntriesAsButtonsOnHover;
        this.queueCommandIfRendered(() -> new UiFileField.SetShowEntriesAsButtonsOnHoverCommand(this.getId(), showEntriesAsButtonsOnHover));
    }

    public FileFieldDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(FileFieldDisplayType displayType) {
        this.displayType = displayType;
        this.queueCommandIfRendered(() -> new UiFileField.SetDisplayTypeCommand(this.getId(), displayType.toUiFileFieldDisplayType()));
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        this.queueCommandIfRendered(() -> new UiFileField.SetMaxFilesCommand(this.getId(), maxFiles));
    }

    public PropertyProvider getUploadButtonPropertyProvider() {
        return this.uploadButtonPropertyProvider;
    }

    public void setUploadButtonPropertyProvider(PropertyProvider propertyProvider) {
        this.uploadButtonPropertyProvider = propertyProvider;
    }

    public void setUploadButtonPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.setUploadButtonPropertyProvider(propertyExtractor);
    }

    public UploadedFileToRecordConverter<RECORD> getUploadedFileToRecordConverter() {
        return this.uploadedFileToRecordConverter;
    }

    public PropertyProvider<RECORD> getFileItemPropertyProvider() {
        return this.fileItemPropertyProvider;
    }

    public void setFileItemPropertyProvider(PropertyProvider<RECORD> fileItemPropertyProvider) {
        this.fileItemPropertyProvider = fileItemPropertyProvider;
    }

    public void setFileItemPropertyExtractor(PropertyExtractor<RECORD> fileItemPropertyExtractor) {
        this.setFileItemPropertyProvider(fileItemPropertyExtractor);
    }
}

