/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.Label;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormField;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.form.layoutpolicy.FormLayoutPolicy;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFieldPlacement;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;

public class ResponsiveFormLayout {
    protected static final String LABEL_NAME_SUFFIX = "Label";
    private final ResponsiveForm responsiveForm;
    private final int minWidth;
    private final List<ResponsiveFormSection> responsiveFormSections = new ArrayList<ResponsiveFormSection>();
    private final ResponsiveFormConfigurationTemplate configurationTemplate;

    protected ResponsiveFormLayout(int minWidth, ResponsiveForm responsiveForm, ResponsiveFormConfigurationTemplate configurationTemplate) {
        this.responsiveForm = responsiveForm;
        this.minWidth = minWidth;
        this.configurationTemplate = configurationTemplate;
    }

    public ResponsiveFormField addField(int row, int column, String propertyName, AbstractField field) {
        ResponsiveFormSection responsiveFormSection = this.getSection();
        FormSectionFieldPlacement fieldPlacementTemplate = this.configurationTemplate.createFieldPlacementTemplate(column);
        ResponsiveFormField sectionField = new ResponsiveFormField(responsiveFormSection, field, row, column, fieldPlacementTemplate);
        responsiveFormSection.addField(sectionField);
        this.responsiveForm.addLayoutField(propertyName, field);
        return sectionField;
    }

    public ResponsiveFormField addField(String propertyName, AbstractField field, int column, int colSpan) {
        int row = this.getSection().getLastNonEmptyRow();
        ResponsiveFormField responsiveFormField = this.addField(row, column, propertyName, field);
        responsiveFormField.setColSpan(colSpan);
        return responsiveFormField;
    }

    public ResponsiveFormField addLabelField(String propertyName, AbstractField field) {
        return this.addLabelField(propertyName, field, 0);
    }

    public ResponsiveFormField addLabelField(AbstractField field) {
        return this.addLabelField(UUID.randomUUID().toString(), field, 0);
    }

    public ResponsiveFormField addLabelField(String propertyName, AbstractField field, int columOffset) {
        int row = this.getSection().getLastNonEmptyRow() + 1;
        int column = this.getSection().getLastNonEmptyColumnInRow(row) + columOffset + 1;
        return this.addField(row, column, propertyName, field);
    }

    public ResponsiveFormField addLabelField(AbstractField field, int columOffset) {
        return this.addLabelField(UUID.randomUUID().toString(), field, columOffset);
    }

    public LabelAndField addLabelAndField(AbstractField field) {
        return this.addLabelAndField(null, null, UUID.randomUUID().toString(), field, true, 0);
    }

    public LabelAndField addLabelAndField(String propertyName, AbstractField field) {
        return this.addLabelAndField(null, null, propertyName, field, true, 0);
    }

    public LabelAndField addLabelAndField(AbstractField field, boolean newRow) {
        return this.addLabelAndField(null, null, UUID.randomUUID().toString(), field, newRow, 0);
    }

    public LabelAndField addLabelAndField(String propertyName, AbstractField field, boolean newRow) {
        return this.addLabelAndField(null, null, propertyName, field, newRow, 0);
    }

    public LabelAndField addLabelAndField(Icon icon, String caption, String propertyName, AbstractField field) {
        return this.addLabelAndField(icon, caption, propertyName, field, true, 0);
    }

    public LabelAndField addLabelAndField(Icon icon, String caption, AbstractField field) {
        return this.addLabelAndField(icon, caption, UUID.randomUUID().toString(), field, true, 0);
    }

    public LabelAndField addLabelAndField(Icon icon, String caption, String propertyName, AbstractField field, boolean newRow) {
        return this.addLabelAndField(icon, caption, propertyName, field, newRow, 0);
    }

    public LabelAndField addLabelAndField(Icon icon, String caption, AbstractField field, boolean newRow) {
        return this.addLabelAndField(icon, caption, UUID.randomUUID().toString(), field, newRow, 0);
    }

    public LabelAndField addLabelAndField(Icon icon, String caption, String propertyName, AbstractField field, boolean newRow, int columnOffset) {
        Label label = null;
        if (icon != null || caption != null) {
            label = new Label(caption, icon);
            label.setTargetComponent(field);
        }
        int row = this.getSection().getLastNonEmptyRow();
        int column = columnOffset;
        if (newRow || row == -1) {
            ++row;
        } else {
            column = this.getSection().getLastNonEmptyColumnInRow(row) + columnOffset + 1;
        }
        ResponsiveFormField labelField = null;
        if (label != null) {
            labelField = this.addComponent(row, column, label);
        }
        ResponsiveFormField responsiveFormField = this.addField(row, column + 1, propertyName, field);
        return new LabelAndField(labelField, responsiveFormField);
    }

    public ResponsiveFormField addComponent(int row, int column, Component field) {
        ResponsiveFormSection responsiveFormSection = this.getSection();
        FormSectionFieldPlacement fieldPlacementTemplate = this.configurationTemplate.createFieldPlacementTemplate(column);
        ResponsiveFormField sectionField = new ResponsiveFormField(responsiveFormSection, field, row, column, fieldPlacementTemplate);
        responsiveFormSection.addField(sectionField);
        this.responsiveForm.addLayoutComponent(field);
        return sectionField;
    }

    public ResponsiveFormField addComponent(Component field, int column, int colSpan) {
        int row = this.getSection().getLastNonEmptyRow();
        ResponsiveFormField responsiveFormField = this.addComponent(row, column, field);
        responsiveFormField.setColSpan(colSpan);
        return responsiveFormField;
    }

    public ResponsiveFormField addLabelComponent(Component field) {
        return this.addLabelComponent(field, 0);
    }

    public ResponsiveFormField addLabelComponent(Component field, int columOffset) {
        int row = this.getSection().getLastNonEmptyRow() + 1;
        int column = this.getSection().getLastNonEmptyColumnInRow(row) + columOffset + 1;
        return this.addComponent(row, column, field);
    }

    public LabelAndField addLabelAndComponent(Component field) {
        return this.addLabelAndComponent(null, null, field, true, 0);
    }

    public LabelAndField addLabelAndComponent(Component field, boolean newRow) {
        return this.addLabelAndComponent(null, null, field, newRow, 0);
    }

    public LabelAndField addLabelAndComponent(Icon icon, String caption, Component field) {
        return this.addLabelAndComponent(icon, caption, field, true, 0);
    }

    public LabelAndField addLabelAndComponent(Icon icon, String caption, Component field, boolean newRow) {
        return this.addLabelAndComponent(icon, caption, field, newRow, 0);
    }

    public LabelAndField addLabelAndComponent(Icon icon, String caption, Component field, boolean newRow, int columnOffset) {
        Label label = null;
        if (icon != null || caption != null) {
            label = new Label(caption, icon);
            label.setTargetComponent(field);
        }
        int row = this.getSection().getLastNonEmptyRow();
        int column = columnOffset;
        if (newRow || row == -1) {
            ++row;
        } else {
            column = this.getSection().getLastNonEmptyColumnInRow(row) + columnOffset + 1;
        }
        ResponsiveFormField labelField = null;
        if (label != null) {
            labelField = this.addComponent(row, column, label);
        }
        ResponsiveFormField responsiveFormField = this.addComponent(row, column + 1, field);
        return new LabelAndField(labelField, responsiveFormField);
    }

    public int getLastNonEmptyRowInSection() {
        return this.getSection().getLastNonEmptyRow();
    }

    public int getLastNonEmptyColumnInSection() {
        return this.getSection().getLastNonEmptyColumn();
    }

    public int getLastNonEmptyColumnInRow(int row) {
        return this.getSection().getLastNonEmptyColumnInRow(row);
    }

    public void setRowConfig(int row, GridRow rowConfig) {
        this.getSection().setRowConfig(row, rowConfig);
    }

    public void setColumnConfig(int colum, GridColumn columnConfig) {
        this.getSection().setColumnConfig(colum, columnConfig);
    }

    protected ResponsiveFormSection getSection() {
        if (this.responsiveFormSections.isEmpty()) {
            this.addSection();
        }
        return this.responsiveFormSections.get(this.responsiveFormSections.size() - 1);
    }

    public ResponsiveFormSection addSection() {
        return this.addSection(null, null);
    }

    public ResponsiveFormSection addSection(Icon icon, String caption) {
        return this.addSection(icon, caption, null);
    }

    public ResponsiveFormSection addSection(Icon icon, String caption, ResponsiveFormConfigurationTemplate configurationTemplate) {
        if (configurationTemplate == null) {
            configurationTemplate = this.responsiveForm.getConfigurationTemplate();
        }
        ResponsiveFormSection responsiveFormSection = new ResponsiveFormSection(this, "section" + (this.responsiveFormSections.size() + 1), configurationTemplate);
        if (configurationTemplate.getSectionTemplate() == null || configurationTemplate.getSectionTemplate().getHeaderTemplate() == null) {
            responsiveFormSection.setHeaderTemplate(BaseTemplate.FORM_SECTION_HEADER);
        }
        if (icon != null || caption != null) {
            responsiveFormSection.setHeaderData(new BaseTemplateRecord(icon, caption));
        }
        this.responsiveFormSections.add(responsiveFormSection);
        return responsiveFormSection;
    }

    protected FormLayoutPolicy createFormLayoutPolicy() {
        FormLayoutPolicy policy = new FormLayoutPolicy();
        policy.setMinWidth(this.minWidth);
        for (ResponsiveFormSection responsiveFormSection : this.responsiveFormSections) {
            policy.addSection(responsiveFormSection.createFormSection());
        }
        return policy;
    }

    protected FormLayoutPolicy createSmallScreenLayout() {
        FormLayoutPolicy policy = new FormLayoutPolicy();
        policy.setMinWidth(0);
        for (ResponsiveFormSection responsiveFormSection : this.responsiveFormSections) {
            policy.addSection(responsiveFormSection.createSmallScreenFormSection());
        }
        return policy;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public static class LabelAndField {
        public ResponsiveFormField label;
        public ResponsiveFormField field;

        public LabelAndField(ResponsiveFormField label, ResponsiveFormField field) {
            this.label = label;
            this.field = field;
        }
    }
}

