/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.format;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiShadow;

public class Shadow {
    private final float offsetX;
    private final float offsetY;
    private final float blur;
    private final float spread;
    private final Color color;

    public static Shadow withSize(float size) {
        return new Shadow(0.0f, 0.0f, size, 0.0f, (Color)RgbaColor.BLACK);
    }

    public Shadow(float offsetX, float offsetY, float blur, float spread, Color color) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blur = blur;
        this.spread = spread;
        this.color = color;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getBlur() {
        return this.blur;
    }

    public float getSpread() {
        return this.spread;
    }

    public Color getColor() {
        return this.color;
    }

    public UiShadow createUiShadow() {
        return new UiShadow(this.color != null ? this.color.toHtmlColorString() : null, this.blur).setOffsetX(this.offsetX).setOffsetY(this.offsetY).setSpread(this.spread);
    }

    public String toCssString() {
        return this.offsetX + "px " + this.offsetY + "px " + this.blur + "px " + this.spread + "px " + (this.color != null ? this.color.toHtmlColorString() : null);
    }
}

