/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.notification;

import org.teamapps.common.format.Color;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiNotification;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;

public class Notification
extends AbstractComponent {
    public final Event<Void> onOpened = new Event();
    public final Event<Boolean> onClosed = new Event();
    private boolean showing;
    private Color backgroundColor = null;
    private Spacing padding = null;
    private int displayTimeInMillis = 3000;
    private boolean dismissible = true;
    private boolean showProgressBar = true;
    private Component content;

    public Notification() {
    }

    public Notification(Component content) {
        this.content = content;
    }

    public static Notification createWithIconAndCaption(Icon icon, String text) {
        return Notification.createWithIconAndTextAndDescription(icon, text, null);
    }

    public static Notification createWithIconAndTextAndDescription(Icon icon, String text, String description) {
        TemplateField templateField = new TemplateField(BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
        templateField.setValue(new BaseTemplateRecord(icon, text, description));
        Notification notification = new Notification();
        notification.setContent(templateField);
        return notification;
    }

    public UiNotification createUiComponent() {
        UiNotification ui = new UiNotification();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        ui.setPadding(this.padding != null ? this.padding.createUiSpacing() : null);
        ui.setDisplayTimeInMillis(this.displayTimeInMillis);
        ui.setDismissible(this.dismissible);
        ui.setProgressBarVisible(this.showProgressBar);
        ui.setContent(this.content != null ? this.content.createUiReference() : null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_NOTIFICATION_OPENED: {
                this.showing = true;
                this.onOpened.fire(null);
                break;
            }
            case UI_NOTIFICATION_CLOSED: {
                this.showing = false;
                this.onClosed.fire(((UiNotification.ClosedEvent)event).getByUser());
            }
        }
    }

    public void close() {
        this.queueCommandIfRendered(() -> new UiNotification.CloseCommand(this.getId()));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Notification setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public Spacing getPadding() {
        return this.padding;
    }

    public Notification setPadding(Spacing padding) {
        this.padding = padding;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    public Notification setDisplayTimeInMillis(int displayTimeInMillis) {
        this.displayTimeInMillis = displayTimeInMillis;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public boolean isDismissible() {
        return this.dismissible;
    }

    public Notification setDismissible(boolean dismissible) {
        this.dismissible = dismissible;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public boolean isShowProgressBar() {
        return this.showProgressBar;
    }

    public Notification setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public Component getContent() {
        return this.content;
    }

    public Notification setContent(Component content) {
        this.content = content;
        this.queueCommandIfRendered(() -> new UiNotification.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public boolean isShowing() {
        return this.showing;
    }
}

