/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.SessionContext;

public class SessionContextResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_PATH = "/files/";
    private final SessionContext sessionContext;
    private final AtomicInteger idGenerator = new AtomicInteger();
    private final Map<Integer, Resource> binaryResourceById = new HashMap<Integer, Resource>();
    private final Map<File, String> fileLinkByFile = new HashMap<File, String>();
    private final Map<String, String> resourceLinkByUniqueIdentifier = new HashMap<String, String>();

    public SessionContextResourceManager(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Resource getBinaryResource(int resourceId) {
        return this.binaryResourceById.get(resourceId);
    }

    public String createFileLink(File file) {
        this.checkThread();
        if (file == null) {
            return null;
        }
        if (this.fileLinkByFile.containsKey(file)) {
            return this.fileLinkByFile.get(file);
        }
        FileResource resource = new FileResource(file);
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String fileLink = this.createLink(id);
        this.fileLinkByFile.put(file, fileLink);
        return fileLink;
    }

    public String createResourceLink(Resource resource, String uniqueIdentifier) {
        this.checkThread();
        if (resource == null) {
            return null;
        }
        if (uniqueIdentifier != null && this.resourceLinkByUniqueIdentifier.containsKey(uniqueIdentifier)) {
            return this.resourceLinkByUniqueIdentifier.get(uniqueIdentifier);
        }
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String resourceLink = this.createLink(id);
        if (uniqueIdentifier != null) {
            this.resourceLinkByUniqueIdentifier.put(uniqueIdentifier, resourceLink);
        }
        return resourceLink;
    }

    private void checkThread() {
        if (SessionContext.current() != this.sessionContext) {
            LOGGER.error("createFileLink called from wrong thread!", (Throwable)new RuntimeException());
        }
    }

    private int createId() {
        return this.idGenerator.incrementAndGet();
    }

    private String createLink(int id) {
        return BASE_PATH + this.sessionContext.getSessionId().getUiSessionId() + "/res" + id;
    }
}

