/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.react;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiReactView;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;

public class ReactView
extends AbstractComponent {
    private String jsx;
    private final Map<String, Component> componentByContainerRefName = new HashMap<String, Component>();
    private final Map<String, String> propValueByPropName = new HashMap<String, String>();

    public ReactView() {
        this(null, Collections.emptyMap(), Collections.emptyMap());
    }

    public ReactView(String jsx) {
        this(jsx, Collections.emptyMap(), Collections.emptyMap());
    }

    public ReactView(String jsx, Map<String, Component> componentByContainerRefName, Map<String, String> propValueByPropName) {
        this.jsx = jsx;
        this.componentByContainerRefName.putAll(componentByContainerRefName);
        this.propValueByPropName.putAll(propValueByPropName);
    }

    @Override
    public UiComponent createUiComponent() {
        UiReactView ui = new UiReactView();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setJsx(this.jsx);
        ui.setComponentByRefName(this.componentByContainerRefName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Component)e.getValue()).createUiReference())));
        ui.setPropValueByPropName(this.propValueByPropName.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
        return ui;
    }

    public String getJsx() {
        return this.jsx;
    }

    public void setJsx(String jsx) {
        this.jsx = jsx;
    }

    public void addComponent(String containerRefName, Component component) {
        this.componentByContainerRefName.put(containerRefName, component);
        this.queueCommandIfRendered(() -> new UiReactView.AddComponentCommand(this.getId(), containerRefName, component.createUiReference()));
    }

    public void removeComponent(Component component) {
        this.componentByContainerRefName.entrySet().removeIf(entry -> entry.getValue() == component);
        this.queueCommandIfRendered(() -> new UiReactView.RemoveComponentCommand(this.getId(), component.createUiReference()));
    }

    public void setProp(String propName, String value) {
        this.propValueByPropName.put(propName, value);
        this.queueCommandIfRendered(() -> new UiReactView.SetPropCommand(this.getId(), propName, value));
    }
}

