/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.model;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.teamapps.ux.component.timegraph.Interval;
import org.teamapps.ux.component.timegraph.TimePartitioning;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphData;
import org.teamapps.ux.component.timegraph.datapoints.LineGraphDataPoint;
import org.teamapps.ux.component.timegraph.datapoints.ListLineGraphData;
import org.teamapps.ux.component.timegraph.model.AbstractLineGraphModel;
import org.teamapps.ux.component.timegraph.model.AggregationType;

public class AggregatingLineGraphModel
extends AbstractLineGraphModel {
    private LineGraphData graphData;
    private AggregationType aggregationType = AggregationType.FIRST_VALUE;
    private boolean addDataPointBeforeAndAfterQueryResult = true;

    public AggregatingLineGraphModel() {
    }

    public AggregatingLineGraphModel(LineGraphData graphData, AggregationType aggregationType) {
        this.graphData = graphData;
        this.aggregationType = aggregationType;
    }

    public void setGraphData(LineGraphData graphData) {
        this.graphData = graphData;
        this.onDataChanged.fire(null);
    }

    public void setAggregationPolicy(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        this.onDataChanged.fire(null);
    }

    @Override
    public LineGraphData getData(TimePartitioning zoomLevel, ZoneId zoneId, Interval neededIntervalX, Interval displayedInterval) {
        long queryStart = AggregatingLineGraphModel.getPartitionStartMilli(displayedInterval.getMin(), zoomLevel, zoneId);
        long queryEnd = AggregatingLineGraphModel.getPartitionEndMilli(displayedInterval.getMax(), zoomLevel, zoneId);
        return AggregatingLineGraphModel.getAggregateDataPoints(this.graphData, zoomLevel, new Interval(queryStart, queryEnd), this.aggregationType, zoneId, this.addDataPointBeforeAndAfterQueryResult);
    }

    public static LineGraphData getAggregateDataPoints(LineGraphData dataPoints, TimePartitioning zoomLevel, Interval alignedInterval, AggregationType aggregationType, ZoneId timeZone, boolean addDataPointBeforeAndAfterQueryResult) {
        ArrayList<LineGraphDataPoint> result = new ArrayList<LineGraphDataPoint>();
        long startPartitionStartMilli = alignedInterval.getMin();
        if (addDataPointBeforeAndAfterQueryResult) {
            startPartitionStartMilli = zoomLevel.decrement(ZonedDateTime.ofInstant(Instant.ofEpochMilli(startPartitionStartMilli), timeZone)).toInstant().toEpochMilli();
        }
        long endPartitionEndMilli = alignedInterval.getMax();
        if (addDataPointBeforeAndAfterQueryResult) {
            endPartitionEndMilli = zoomLevel.increment(Instant.ofEpochMilli(alignedInterval.getMax()).atZone(timeZone)).toInstant().toEpochMilli();
        }
        long currentPartitionStartMilli = startPartitionStartMilli;
        long nextPartitionStartMilli = zoomLevel.increment(ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentPartitionStartMilli), timeZone)).toInstant().toEpochMilli();
        int i = 0;
        do {
            long tsMilli;
            Double aggregateValue = null;
            int count = 0;
            while (i < dataPoints.size() && (tsMilli = (long)dataPoints.getX(i)) < nextPartitionStartMilli) {
                if (tsMilli >= currentPartitionStartMilli) {
                    ++count;
                    double y = dataPoints.getY(i);
                    if (aggregationType == AggregationType.FIRST_VALUE) {
                        aggregateValue = aggregateValue == null ? y : aggregateValue;
                        break;
                    }
                    if (aggregationType == AggregationType.MAX) {
                        aggregateValue = aggregateValue == null || aggregateValue < y ? y : aggregateValue;
                    } else if (aggregationType == AggregationType.MIN) {
                        aggregateValue = aggregateValue == null || aggregateValue > y ? y : aggregateValue;
                    } else if (aggregationType == AggregationType.AVERAGE) {
                        aggregateValue = aggregateValue == null ? y : aggregateValue + y;
                    }
                }
                ++i;
            }
            if (count > 0 && aggregateValue != null) {
                double y = aggregationType == AggregationType.AVERAGE ? aggregateValue / (double)count : aggregateValue;
                result.add(new LineGraphDataPoint(currentPartitionStartMilli, y));
            }
            currentPartitionStartMilli = nextPartitionStartMilli;
            nextPartitionStartMilli = zoomLevel.increment(AggregatingLineGraphModel.getPartitionStart(nextPartitionStartMilli, zoomLevel, timeZone)).toInstant().toEpochMilli();
        } while (currentPartitionStartMilli < endPartitionEndMilli);
        return new ListLineGraphData(result, new Interval(startPartitionStartMilli, endPartitionEndMilli));
    }

    private static ZonedDateTime getPartitionStart(long timestampMillis, TimePartitioning partitionUnit, ZoneId timeZone) {
        return partitionUnit.getPartitionStart(ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), timeZone));
    }

    private static long getPartitionStartMilli(long timestampMillis, TimePartitioning partitionUnit, ZoneId timeZone) {
        return partitionUnit.getPartitionStart(Instant.ofEpochMilli(timestampMillis).atZone(timeZone)).toInstant().toEpochMilli();
    }

    private static long getPartitionEndMilli(long timestampMillis, TimePartitioning partitionUnit, ZoneId timeZone) {
        return partitionUnit.getPartitionEnd(Instant.ofEpochMilli(timestampMillis).atZone(timeZone)).toInstant().toEpochMilli();
    }

    @Override
    public Interval getDomainX() {
        long minX = this.graphData.streamX().mapToLong(x -> (long)x).min().orElse(0L);
        long maxX = this.graphData.streamX().mapToLong(x -> (long)x).max().orElse(1L);
        return new Interval(minX, maxX);
    }

    public boolean isAddDataPointBeforeAndAfterQueryResult() {
        return this.addDataPointBeforeAndAfterQueryResult;
    }

    public void setAddDataPointBeforeAndAfterQueryResult(boolean addDataPointBeforeAndAfterQueryResult) {
        this.addDataPointBeforeAndAfterQueryResult = addDataPointBeforeAndAfterQueryResult;
    }
}

