/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.event;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.event.EventListener;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.LockableSessionContext;
import org.teamapps.ux.session.SessionContext;

public class Event<EVENT_DATA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private List<EventListener<EVENT_DATA>> listeners = new CopyOnWriteArrayList<EventListener<EVENT_DATA>>();
    private EVENT_DATA lastEventData;

    public void addListener(EventListener<EVENT_DATA> listener) {
        LockableSessionContext currentSessionContext = CurrentSessionContext.getOrNull();
        if (currentSessionContext != null) {
            this.listeners.add(eventData -> currentSessionContext.runWithContext(() -> listener.onEvent(eventData)));
            this.removeWhenSessionDestroyed(listener, currentSessionContext);
        } else {
            this.listeners.add(listener);
        }
    }

    private void removeWhenSessionDestroyed(EventListener<EVENT_DATA> listener, SessionContext currentSessionContext) {
        if (this != currentSessionContext.onDestroyed()) {
            WeakReference<EventListener<EVENT_DATA>> listenerWeakReference = new WeakReference<EventListener<EVENT_DATA>>(listener);
            currentSessionContext.onDestroyed().listeners.add(aVoid -> {
                EventListener l = (EventListener)listenerWeakReference.get();
                if (l != null) {
                    this.removeListener(l);
                }
            });
        }
    }

    public void removeListener(EventListener<EVENT_DATA> listener) {
        this.listeners.remove(listener);
    }

    public void fire(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (EventListener<EVENT_DATA> listener : this.listeners) {
            listener.onEvent(eventData);
        }
    }

    public void fireIfChanged(EVENT_DATA eventData) {
        if (!Objects.equals(this.lastEventData, eventData)) {
            this.fire(eventData);
        }
    }

    public <T> Event<T> converted(Function<EVENT_DATA, T> converter) {
        Event newEvent = new Event();
        this.addListener(data -> newEvent.fire(converter.apply(data)));
        return newEvent;
    }
}

