/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.data;

import java.util.function.Supplier;
import org.teamapps.ux.application.data.RecordDeletableDecider;
import org.teamapps.ux.application.data.RecordDeletionHandler;
import org.teamapps.ux.application.data.RecordEditableDecider;
import org.teamapps.ux.application.data.RecordHandler;
import org.teamapps.ux.application.data.RecordUpdateHandler;
import org.teamapps.ux.application.data.RecordValidator;
import org.teamapps.ux.application.data.TableRecordHandler;
import org.teamapps.ux.application.data.UpdateMode;
import org.teamapps.ux.application.filter.FilterProvider;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.table.Table;

public class TableRecordHandlerBuilder<RECORD> {
    private final Table<RECORD> table;
    private final UpdateMode updateMode;
    private View view;
    private boolean emptyRecordsOnTop;
    private boolean ensureEmptyRecordRow;
    private RecordEditableDecider<RECORD> recordEditableDecider;
    private RecordDeletableDecider<RECORD> recordDeletableDecider;
    private RecordValidator<RECORD> recordValidator;
    private RecordUpdateHandler<RECORD> recordUpdateHandler;
    private RecordDeletionHandler<RECORD> recordDeletionHandler;
    private RecordHandler<RECORD> recordHandler;
    private Supplier<RECORD> emptyRecordSupplier;
    private FilterProvider<RECORD> filterProvider;

    public TableRecordHandlerBuilder(Table<RECORD> table, UpdateMode updateMode) {
        this.table = table;
        this.updateMode = updateMode;
    }

    public TableRecordHandlerBuilder<RECORD> setView(View view) {
        this.view = view;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setEmptyRecordsOnTop(boolean emptyRecordsOnTop) {
        this.emptyRecordsOnTop = emptyRecordsOnTop;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setEnsureEmptyRecordRow(boolean ensureEmptyRecordRow) {
        this.ensureEmptyRecordRow = ensureEmptyRecordRow;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordEditableDecider(RecordEditableDecider<RECORD> recordEditableDecider) {
        this.recordEditableDecider = recordEditableDecider;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordDeletableDecider(RecordDeletableDecider<RECORD> recordDeletableDecider) {
        this.recordDeletableDecider = recordDeletableDecider;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordValidator(RecordValidator<RECORD> recordValidator) {
        this.recordValidator = recordValidator;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordUpdateHandler(RecordUpdateHandler<RECORD> recordUpdateHandler) {
        this.recordUpdateHandler = recordUpdateHandler;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordDeletionHandler(RecordDeletionHandler<RECORD> recordDeletionHandler) {
        this.recordDeletionHandler = recordDeletionHandler;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setRecordHandler(RecordHandler<RECORD> recordHandler) {
        this.recordHandler = recordHandler;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setEmptyRecordSupplier(Supplier<RECORD> emptyRecordSupplier) {
        this.emptyRecordSupplier = emptyRecordSupplier;
        return this;
    }

    public TableRecordHandlerBuilder<RECORD> setFilterProvider(FilterProvider<RECORD> filterProvider) {
        this.filterProvider = filterProvider;
        return this;
    }

    public TableRecordHandler<RECORD> createTableRecordHandler() {
        return new TableRecordHandler<RECORD>(this.table, this.updateMode, this.emptyRecordsOnTop, this.ensureEmptyRecordRow, this.recordEditableDecider, this.recordDeletableDecider, this.recordValidator, this.recordUpdateHandler, this.recordDeletionHandler, this.recordHandler, this.emptyRecordSupplier, this.filterProvider, this.view);
    }
}

