/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.layout;

import org.teamapps.ux.component.workspacelayout.SplitDirection;
import org.teamapps.ux.component.workspacelayout.definition.LayoutItemDefinition;
import org.teamapps.ux.component.workspacelayout.definition.SplitPaneDefinition;
import org.teamapps.ux.component.workspacelayout.definition.SplitSize;
import org.teamapps.ux.component.workspacelayout.definition.ViewGroupDefinition;

public class StandardLayout {
    public static final String LEFT = "left";
    public static final String LEFT_BOTTOM = "left-bottom";
    public static final String TOP = "top";
    public static final String CENTER = "center";
    public static final String CENTER_BOTTOM = "center-bottom";
    public static final String RIGHT = "right";
    public static final String RIGHT_BOTTOM = "right-bottom";
    public final LayoutItemDefinition rootItem;
    public final ViewGroupDefinition leftViewGroup = new ViewGroupDefinition("left", true);
    public final ViewGroupDefinition leftBottomViewGroup = new ViewGroupDefinition("left-bottom", true);
    public final ViewGroupDefinition topViewGroup = new ViewGroupDefinition("top", true);
    public final ViewGroupDefinition centerViewGroup = new ViewGroupDefinition("center", true);
    public final ViewGroupDefinition centerBottomViewGroup = new ViewGroupDefinition("center-bottom", true);
    public final ViewGroupDefinition rightViewGroup = new ViewGroupDefinition("right", true);
    public final ViewGroupDefinition rightBottomViewGroup = new ViewGroupDefinition("right-bottom", true);

    public static LayoutItemDefinition createLayout() {
        return new StandardLayout().getRootItem();
    }

    public static LayoutItemDefinition createLayout(SplitSize leftWidth, SplitSize leftHeight, SplitSize topHeight, SplitSize centerWidth, SplitSize centerHeight, SplitSize rightHeight) {
        return new StandardLayout(leftWidth, leftHeight, topHeight, centerWidth, centerHeight, rightHeight).getRootItem();
    }

    public StandardLayout() {
        this(SplitSize.firstFixed(250.0f), SplitSize.relative(0.5f), SplitSize.firstFixed(150.0f), SplitSize.relative(0.5f), SplitSize.relative(0.5f), SplitSize.relative(0.5f));
    }

    public StandardLayout(SplitSize leftWidth, SplitSize leftHeight, SplitSize topHeight, SplitSize centerWidth, SplitSize centerHeight, SplitSize rightHeight) {
        this.rootItem = new SplitPaneDefinition("leftSplit", SplitDirection.VERTICAL, leftWidth, new SplitPaneDefinition("leftInner", SplitDirection.HORIZONTAL, leftHeight, this.leftViewGroup, this.leftBottomViewGroup), new SplitPaneDefinition("topSplit", SplitDirection.HORIZONTAL, topHeight, this.topViewGroup, new SplitPaneDefinition("centerRightSplit", SplitDirection.VERTICAL, centerWidth, new SplitPaneDefinition("centerSplit", SplitDirection.HORIZONTAL, centerHeight, this.centerViewGroup, this.centerBottomViewGroup), new SplitPaneDefinition("rightSplit", SplitDirection.HORIZONTAL, rightHeight, this.rightViewGroup, this.rightBottomViewGroup))));
    }

    public LayoutItemDefinition getRootItem() {
        return this.rootItem;
    }

    public ViewGroupDefinition getLeftViewGroup() {
        return this.leftViewGroup;
    }

    public ViewGroupDefinition getLeftBottomViewGroup() {
        return this.leftBottomViewGroup;
    }

    public ViewGroupDefinition getTopViewGroup() {
        return this.topViewGroup;
    }

    public ViewGroupDefinition getCenterViewGroup() {
        return this.centerViewGroup;
    }

    public ViewGroupDefinition getCenterBottomViewGroup() {
        return this.centerBottomViewGroup;
    }

    public ViewGroupDefinition getRightViewGroup() {
        return this.rightViewGroup;
    }

    public ViewGroupDefinition getRightBottomViewGroup() {
        return this.rightBottomViewGroup;
    }
}

