/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.ux.application.validation.RecordValue;
import org.teamapps.ux.application.validation.RecordValueChange;

public class RecordChangeSet<RECORD> {
    private RECORD unmodifiedRecord;
    private Map<String, RecordValueChange> valueChangeByPropertyKey = new HashMap<String, RecordValueChange>();

    public RecordChangeSet(RECORD unmodifiedRecord) {
        this.unmodifiedRecord = unmodifiedRecord;
    }

    public RecordChangeSet(RECORD unmodifiedRecord, Map<String, Object> changedValues) {
        this.unmodifiedRecord = unmodifiedRecord;
        changedValues.entrySet().forEach(entry -> this.addValueChange(new RecordValueChange((String)entry.getKey(), entry.getValue())));
    }

    public RecordChangeSet(RECORD unmodifiedRecord, List<RecordValueChange> valueChanges) {
        this.unmodifiedRecord = unmodifiedRecord;
        for (RecordValueChange valueChange : valueChanges) {
            this.addValueChange(valueChange);
        }
    }

    public boolean isChanged() {
        return !this.valueChangeByPropertyKey.isEmpty();
    }

    public RecordChangeSet addValueChange(RecordValueChange valueChange) {
        this.valueChangeByPropertyKey.put(valueChange.getPropertyName(), valueChange);
        return this;
    }

    public RECORD getUnmodifiedRecord() {
        return this.unmodifiedRecord;
    }

    public RecordValueChange getValueChange(String propertyName) {
        return this.valueChangeByPropertyKey.get(propertyName);
    }

    public List<RecordValueChange> getValueChanges() {
        return new ArrayList<RecordValueChange>(this.valueChangeByPropertyKey.values());
    }

    public List<RecordValue> getRecordValues(PropertyProvider<RECORD> propertyProvider, String ... requiredPropertyNames) {
        ArrayList<RecordValue> values = new ArrayList<RecordValue>();
        HashSet<String> requiredPropertyNameSet = new HashSet<String>(Arrays.asList(requiredPropertyNames));
        this.valueChangeByPropertyKey.entrySet().forEach(entry -> {
            boolean required = requiredPropertyNameSet.contains(entry.getKey());
            RecordValueChange valueChange = (RecordValueChange)entry.getValue();
            values.add(new RecordValue((String)entry.getKey(), required, valueChange.getValue(), true));
        });
        requiredPropertyNameSet.forEach(propertyName -> {
            if (!this.valueChangeByPropertyKey.containsKey(propertyName)) {
                values.add(new RecordValue((String)propertyName, true, propertyProvider.getValue(this.unmodifiedRecord, (String)propertyName), false));
            }
        });
        return values;
    }
}

