/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.calendar;

import java.time.Instant;
import org.teamapps.common.format.Color;
import org.teamapps.ux.component.calendar.CalendarEventRenderingStyle;

public class CalendarEvent<RECORD> {
    private long start;
    private long end;
    private boolean allDay;
    private boolean allowDragOperations;
    private Color backgroundColor;
    private Color borderColor;
    private CalendarEventRenderingStyle rendering = CalendarEventRenderingStyle.DEFAULT;
    private RECORD record;

    public CalendarEvent(Instant start, Instant end, String title, boolean allDay, RECORD record) {
        this.start = start.toEpochMilli();
        this.end = end.toEpochMilli();
        this.allDay = allDay;
        this.record = record;
    }

    public CalendarEvent(Instant start, Instant end, String title, boolean allDay) {
        this(start, end, title, allDay, null);
    }

    public CalendarEvent(Instant start, Instant end, String title, RECORD record) {
        this(start, end, title, false, record);
    }

    public CalendarEvent(Instant start, Instant end, String title) {
        this(start, end, title, false, null);
    }

    public CalendarEvent(long start, long end, String title, boolean allDay, RECORD record) {
        this.start = start;
        this.end = end;
        this.allDay = allDay;
        this.record = record;
    }

    public CalendarEvent(long start, long end, String title, boolean allDay) {
        this(start, end, title, allDay, null);
    }

    public CalendarEvent(long start, long end, String title, RECORD record) {
        this(start, end, title, false, record);
    }

    public CalendarEvent(long start, long end, String title) {
        this(start, end, title, false, null);
    }

    public Instant getStart() {
        return Instant.ofEpochMilli(this.start);
    }

    public long getStartAsLong() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setStart(Instant start) {
        this.start = start.toEpochMilli();
    }

    public Instant getEnd() {
        return Instant.ofEpochMilli(this.end);
    }

    public long getEndAsLong() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public boolean isAllowDragOperations() {
        return this.allowDragOperations;
    }

    public void setAllowDragOperations(boolean allowDragOperations) {
        this.allowDragOperations = allowDragOperations;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public CalendarEventRenderingStyle getRendering() {
        return this.rendering;
    }

    public void setRendering(CalendarEventRenderingStyle rendering) {
        this.rendering = rendering;
    }

    public RECORD getRecord() {
        return this.record;
    }

    public void setRecord(RECORD record) {
        this.record = record;
    }
}

