/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.dialogue;

import org.teamapps.event.Event;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.window.Window;

public class Dialogue
extends Window {
    public Event<Boolean> onResult = new Event();
    private final ComboBox<BaseTemplateRecord<?>> comboBox;
    private final Button<?> okButton;
    private final Button<?> cancelButton;

    public static Event<Boolean> showOkCancel(Icon icon, String title, String text) {
        return Dialogue.showOkCancel(new BaseTemplateRecord(icon, title, text));
    }

    public static Event<Boolean> showOkCancel(BaseTemplateRecord<?> record) {
        Dialogue dialogue = new Dialogue();
        dialogue.setValues(record);
        dialogue.setIcon(record.getIcon());
        dialogue.setTitle(record.getCaption());
        dialogue.setModal(true);
        dialogue.show(250);
        return dialogue.onResult;
    }

    public static Dialogue createOkCancel(Icon icon, String title) {
        return Dialogue.createOkCancel(icon, title, title);
    }

    public static Dialogue createOkCancel(Icon icon, String title, String text) {
        Dialogue dialogue = new Dialogue();
        dialogue.setValues(icon, title, text);
        dialogue.setIcon(icon);
        dialogue.setTitle(title);
        dialogue.setModal(true);
        return dialogue;
    }

    public static Event<Boolean> showOk(Icon icon, String title) {
        return Dialogue.showOk(icon, title, title);
    }

    public static Event<Boolean> showOk(Icon icon, String title, String text) {
        Dialogue dialogue = new Dialogue();
        dialogue.getCancelButton().setVisible(false);
        dialogue.setValues(icon, title, text);
        dialogue.setIcon(icon);
        dialogue.setTitle(title);
        dialogue.setModal(false);
        dialogue.show(250);
        return dialogue.onResult;
    }

    public Dialogue() {
        ResponsiveFormConfigurationTemplate template = new ResponsiveFormConfigurationTemplate();
        template.setRowTemplate(new GridRow().setHeightPolicy(SizingPolicy.AUTO));
        template.setColumnTemplate(new GridColumn(SizingPolicy.AUTO));
        ResponsiveForm responsiveForm = new ResponsiveForm(template);
        this.setContent(responsiveForm);
        this.setWidth(500);
        this.setHeight(200);
        ResponsiveFormLayout formLayout = responsiveForm.addResponsiveFormLayout(200);
        formLayout.addSection().setDrawHeaderLine(false).setMargin(new Spacing(10)).setGridGap(20);
        this.comboBox = new ComboBox();
        this.comboBox.setTemplate(BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.comboBox.setEditingMode(FieldEditingMode.READONLY);
        formLayout.addField(0, 0, "data", this.comboBox).setHorizontalAlignment(HorizontalElementAlignment.CENTER).setColSpan(3);
        this.okButton = Button.create((Icon)MaterialIcon.CHECK, "OK");
        this.okButton.onValueChanged.addListener(o -> {
            this.close(250);
            this.getSessionContext().flushCommands();
            this.onResult.fire(true);
        });
        this.cancelButton = Button.create((Icon)MaterialIcon.CANCEL, "Abbrechen");
        this.cancelButton.onValueChanged.addListener(o -> {
            this.close(250);
            this.getSessionContext().flushCommands();
            this.onResult.fire(false);
        });
        formLayout.addField(1, 1, "ok", this.okButton);
        formLayout.addField(1, 2, "cancel", this.cancelButton);
    }

    public void setValues(BaseTemplateRecord<?> record) {
        this.comboBox.setValue(record);
    }

    public void setValues(Icon icon, String title, String text) {
        this.comboBox.setValue(new BaseTemplateRecord(icon, title, text));
    }

    public ComboBox<BaseTemplateRecord<?>> getComboBox() {
        return this.comboBox;
    }

    public Button<?> getOkButton() {
        return this.okButton;
    }

    public Button<?> getCancelButton() {
        return this.cancelButton;
    }
}

