/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import java.time.Instant;
import org.teamapps.dto.AbstractUiDateTimeField;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiInstantDateTimeField;
import org.teamapps.ux.component.field.datetime.AbstractDateTimeField;

public class InstantDateTimeField
extends AbstractDateTimeField<InstantDateTimeField, Instant> {
    protected String timeZoneId = null;

    public UiField createUiComponent() {
        UiInstantDateTimeField uiField = new UiInstantDateTimeField(this.getId());
        this.mapAbstractDateTimeFieldUiValues((AbstractUiDateTimeField)uiField);
        uiField.setTimeZoneId(this.timeZoneId);
        return uiField;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        this.queueCommandIfRendered(() -> new UiInstantDateTimeField.SetTimeZoneIdCommand(this.getId(), timeZoneId));
    }

    @Override
    public Instant convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(((Number)value).longValue());
    }
}

