/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.itemview;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiItemView;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.itemview.ItemClickedEventData;
import org.teamapps.ux.component.itemview.ItemGroup;
import org.teamapps.ux.component.itemview.ItemGroupContainer;
import org.teamapps.ux.component.itemview.ItemViewItemBackgroundMode;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class ItemView<HEADERRECORD, RECORD>
extends AbstractComponent {
    public Event<ItemClickedEventData<RECORD>> onItemClicked = new Event();
    private final List<ItemGroup<HEADERRECORD, RECORD>> itemGroups = new ArrayList<ItemGroup<HEADERRECORD, RECORD>>();
    private int horizontalPadding = 10;
    private int verticalPadding = 0;
    private int groupSpacing;
    private ItemViewItemBackgroundMode itemBackgroundMode = ItemViewItemBackgroundMode.LIGHT;
    private String filter;
    private Template groupHeaderTemplate = BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE;
    private PropertyExtractor<HEADERRECORD> headerPropertyExtractor = new BeanPropertyExtractor<HEADERRECORD>();

    public ItemView() {
        this(null);
    }

    public ItemView(List<ItemGroup<HEADERRECORD, RECORD>> itemGroups) {
        if (itemGroups != null) {
            itemGroups.forEach(this::addGroup);
        }
    }

    public Template getGroupHeaderTemplate() {
        return this.groupHeaderTemplate;
    }

    public void setGroupHeaderTemplate(Template groupHeaderTemplate) {
        this.groupHeaderTemplate = groupHeaderTemplate;
        this.reRenderIfRendered();
    }

    public List<ItemGroup> getItemGroups() {
        return new ArrayList<ItemGroup>(this.itemGroups);
    }

    public ItemGroup<HEADERRECORD, RECORD> addGroup() {
        return this.addGroup(null, null);
    }

    public ItemGroup<HEADERRECORD, RECORD> addGroup(HEADERRECORD headerRecord) {
        return this.addGroup(headerRecord, null);
    }

    public ItemGroup<HEADERRECORD, RECORD> addGroup(HEADERRECORD headerRecord, Template itemTemplate) {
        ItemGroup group = new ItemGroup(headerRecord, itemTemplate);
        this.addGroup(group);
        return group;
    }

    public void addGroup(final ItemGroup<HEADERRECORD, RECORD> group) {
        this.itemGroups.add(group);
        group.setContainer(new ItemGroupContainer<HEADERRECORD, RECORD>(){

            @Override
            public UiIdentifiableClientRecord createHeaderClientRecord(HEADERRECORD headerRecord) {
                UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
                clientRecord.setValues(ItemView.this.headerPropertyExtractor.getValues(headerRecord, ItemView.this.groupHeaderTemplate.getDataKeys()));
                return clientRecord;
            }

            @Override
            public void handleAddItem(UiIdentifiableClientRecord itemClientRecord, Consumer<Void> uiCommandCallback) {
                if (ItemView.this.isRendered()) {
                    ItemView.this.getSessionContext().queueCommand(new UiItemView.AddItemCommand(ItemView.this.getId(), group.getClientId(), itemClientRecord), uiCommandCallback);
                } else {
                    uiCommandCallback.accept(null);
                }
            }

            @Override
            public void handleRemoveItem(int itemClientRecordId, Consumer<Void> uiCommandCallback) {
                if (ItemView.this.isRendered()) {
                    ItemView.this.getSessionContext().queueCommand(new UiItemView.RemoveItemCommand(ItemView.this.getId(), group.getClientId(), itemClientRecordId), uiCommandCallback);
                }
            }

            @Override
            public void handleRefreshRequired() {
                ItemView.this.queueCommandIfRendered(() -> new UiItemView.RefreshItemGroupCommand(ItemView.this.getId(), group.createUiItemViewItemGroup()));
            }
        });
        this.queueCommandIfRendered(() -> new UiItemView.AddItemGroupCommand(this.getId(), group.createUiItemViewItemGroup()));
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.queueCommandIfRendered(() -> new UiItemView.SetFilterCommand(this.getId(), filter));
    }

    public void removeAllGroups() {
        new ArrayList<ItemGroup<HEADERRECORD, RECORD>>(this.itemGroups).forEach((Consumer<ItemGroup<HEADERRECORD, RECORD>>)((Consumer<ItemGroup>)this::removeItemGroup));
    }

    public void removeItemGroup(ItemGroup itemGroup) {
        this.itemGroups.remove(itemGroup);
        this.queueCommandIfRendered(() -> new UiItemView.RemoveItemGroupCommand(this.getId(), itemGroup.getClientId()));
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        this.reRenderIfRendered();
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public void setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        this.reRenderIfRendered();
    }

    public int getGroupSpacing() {
        return this.groupSpacing;
    }

    public void setGroupSpacing(int groupSpacing) {
        this.groupSpacing = groupSpacing;
        this.reRenderIfRendered();
    }

    public ItemViewItemBackgroundMode getItemBackgroundMode() {
        return this.itemBackgroundMode;
    }

    public void setItemBackgroundMode(ItemViewItemBackgroundMode itemBackgroundMode) {
        this.itemBackgroundMode = itemBackgroundMode;
        this.reRenderIfRendered();
    }

    public PropertyExtractor<HEADERRECORD> getHeaderPropertyExtractor() {
        return this.headerPropertyExtractor;
    }

    public void setHeaderPropertyExtractor(PropertyExtractor<HEADERRECORD> headerPropertyExtractor) {
        this.headerPropertyExtractor = headerPropertyExtractor;
        this.reRenderIfRendered();
    }

    @Override
    public UiComponent createUiComponent() {
        UiItemView uiItemView = new UiItemView(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiItemView);
        uiItemView.setGroupHeaderTemplate(this.groupHeaderTemplate != null ? this.groupHeaderTemplate.createUiTemplate() : null);
        uiItemView.setItemGroups(this.itemGroups.stream().map(group -> group.createUiItemViewItemGroup()).collect(Collectors.toList()));
        uiItemView.setHorizontalPadding(this.horizontalPadding);
        uiItemView.setVerticalPadding(this.verticalPadding);
        uiItemView.setGroupSpacing(this.groupSpacing);
        uiItemView.setItemBackgroundMode(this.itemBackgroundMode.toUiItemBackgroundMode());
        uiItemView.setFilter(this.filter);
        return uiItemView;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_ITEM_VIEW_ITEM_CLICKED: {
                UiItemView.ItemClickedEvent itemClickedEvent = (UiItemView.ItemClickedEvent)event;
                ItemGroup<HEADERRECORD, RECORD> itemGroup = this.getItemGroupByClientId(itemClickedEvent.getGroupId());
                if (itemGroup == null) break;
                RECORD item = itemGroup.getItemByClientId(itemClickedEvent.getItemId());
                this.onItemClicked.fire(new ItemClickedEventData<RECORD>(itemGroup, item));
            }
        }
    }

    private ItemGroup<HEADERRECORD, RECORD> getItemGroupByClientId(String clientId) {
        return this.itemGroups.stream().filter(group -> Objects.equals(group.getClientId(), clientId)).findFirst().orElse(null);
    }

    @Override
    protected void doDestroy() {
    }
}

