/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.media;

import java.util.Arrays;
import java.util.List;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentReference;
import org.teamapps.dto.UiEvent;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.media.MediaTrackData;
import org.teamapps.ux.component.media.MediaTrackGraph;
import org.teamapps.ux.component.media.VideoPlayer;
import org.teamapps.ux.component.splitpane.SplitDirection;
import org.teamapps.ux.component.splitpane.SplitPane;
import org.teamapps.ux.component.splitpane.SplitSizePolicy;
import org.teamapps.ux.component.toolbar.ToolbarButton;

public class MediaPlayer
extends AbstractComponent {
    private VideoPlayer videoPlayer = new VideoPlayer(null);
    private MediaTrackGraph trackGraph;
    private SplitPane splitPane;

    public MediaPlayer() {
        this.videoPlayer.onVideoPlayerProgress.addListener(position -> {
            if (this.trackGraph != null) {
                this.trackGraph.setCursorPosition(position * 1000);
            }
        });
        this.splitPane = new SplitPane(SplitDirection.HORIZONTAL, SplitSizePolicy.LAST_FIXED, 150.0f);
        this.splitPane.setFirstChildMinSize(0);
        this.splitPane.setLastChildMinSize(70);
        this.splitPane.setCollapseEmptyChildren(true);
        this.splitPane.setFirstChild(this.videoPlayer);
        this.splitPane.setLastChild(this.trackGraph);
    }

    public List<ToolbarButton> createToolbarControls() {
        ToolbarButton play = ToolbarButton.createLarge((Icon)MaterialIcon.PLAY_ARROW, "Play", null);
        ToolbarButton pause = ToolbarButton.createLarge((Icon)MaterialIcon.PAUSE, "Pause", null);
        ToolbarButton stop = ToolbarButton.createLarge((Icon)MaterialIcon.STOP, "Stop", null);
        pause.setVisible(false);
        play.onClick.addListener(toolbarButtonClickEvent -> {
            play.setVisible(false);
            pause.setVisible(true);
            this.videoPlayer.play();
        });
        pause.onClick.addListener(toolbarButtonClickEvent -> {
            play.setVisible(true);
            pause.setVisible(false);
            this.videoPlayer.pause();
        });
        stop.onClick.addListener(toolbarButtonClickEvent -> {
            play.setVisible(true);
            pause.setVisible(false);
            this.videoPlayer.pause();
            this.videoPlayer.setPosition(0);
        });
        return Arrays.asList(play, pause, stop);
    }

    public void setPlayerData(String url, MediaTrackData trackData) {
        this.videoPlayer.setUrl(url);
        this.trackGraph = new MediaTrackGraph(trackData);
        this.splitPane.setLastChild(this.trackGraph);
        this.trackGraph.onTimeSelection.addListener(timeSelection -> this.videoPlayer.setPosition((int)timeSelection.start / 1000));
    }

    public VideoPlayer getVideoPlayer() {
        return this.videoPlayer;
    }

    public MediaTrackGraph getTrackGraph() {
        return this.trackGraph;
    }

    public SplitPane getSplitPane() {
        return this.splitPane;
    }

    @Override
    public UiComponent createUiComponent() {
        return this.splitPane.createUiComponent();
    }

    @Override
    public UiComponentReference createUiComponentReference() {
        return this.splitPane.createUiComponentReference();
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    @Override
    protected void doDestroy() {
    }
}

