/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.rootpanel;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiRootPanel;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.animation.Animation;

public class RootPanel
extends AbstractComponent
implements Container {
    private Component content;
    private List<Component> components = new ArrayList<Component>();

    @Override
    protected void doDestroy() {
        this.components.forEach(Component::destroy);
    }

    @Override
    public UiComponent createUiComponent() {
        UiRootPanel uiRootPanel = new UiRootPanel(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiRootPanel);
        if (this.content != null) {
            uiRootPanel.setVisibleChildComponentId(this.content.getId());
        }
        if (!this.components.isEmpty()) {
            List uiComponents = this.components.stream().map(component -> component.createUiComponentReference()).collect(Collectors.toList());
            uiRootPanel.setChildComponents(uiComponents);
        }
        return uiRootPanel;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public void preloadContent(Component component) {
        if (!this.components.contains(component)) {
            this.components.add(component);
            component.setParent(this);
            this.queueCommandIfRendered(() -> new UiRootPanel.AddChildComponentCommand(this.getId(), component.createUiComponentReference(), false));
        }
    }

    public void setContent(Component component) {
        this.setContent(component, Animation.NONE, 0L);
    }

    public void setContent(Component component, Animation animation, long animationDuration) {
        if (component != null) {
            this.preloadContent(component);
        }
        this.content = component;
        this.queueCommandIfRendered(() -> new UiRootPanel.SetVisibleChildComponentCommand(this.getId(), component != null ? component.getId() : null, animation.toUiComponentRevealAnimation(), animationDuration));
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
        if (this.content == component) {
            this.setContent(this.components.isEmpty() ? null : this.components.get(0));
        }
        this.queueCommandIfRendered(() -> new UiRootPanel.RemoveChildComponentCommand(this.getId(), component.getId()));
    }

    public void removeAllComponents() {
        this.components.stream().forEach(component -> this.queueCommandIfRendered(() -> new UiRootPanel.RemoveChildComponentCommand(this.getId(), component.getId())));
        this.components.clear();
        this.setContent(null);
    }

    public Component getContent() {
        return this.content;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public boolean isEffectivelyVisible() {
        return this.isRendered() && this.isVisible();
    }

    @Override
    public boolean isChildVisible(Component child) {
        return this.isVisible() && this.content == child;
    }
}

