/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.BeanPropertyInjector;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyInjector;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiTable;
import org.teamapps.dto.UiTableClientRecord;
import org.teamapps.dto.UiTableDataRequest;
import org.teamapps.event.Event;
import org.teamapps.event.EventListener;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Container;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldMessage;
import org.teamapps.ux.component.table.CellEditingStartedEvent;
import org.teamapps.ux.component.table.CellEditingStoppedEvent;
import org.teamapps.ux.component.table.ColumnSizeChangeEventData;
import org.teamapps.ux.component.table.FieldOrderChangeEventData;
import org.teamapps.ux.component.table.FieldValueChangedEventData;
import org.teamapps.ux.component.table.ListTableModel;
import org.teamapps.ux.component.table.SelectionFrame;
import org.teamapps.ux.component.table.SortingChangedEventData;
import org.teamapps.ux.component.table.TableCellCoordinates;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableDataRequestEventData;
import org.teamapps.ux.component.table.TableModel;

public class Table<RECORD>
extends AbstractComponent
implements Container {
    private static final Logger LOGGER = LoggerFactory.getLogger(Table.class);
    public final Event<CellEditingStartedEvent<RECORD, Object>> onCellEditingStarted = new Event();
    public final Event<CellEditingStoppedEvent<RECORD>> onCellEditingStopped = new Event();
    public final Event<FieldValueChangedEventData<RECORD, Object>> onCellValueChanged = new Event();
    public final Event<RECORD> onRowSelected = new Event();
    public final Event<List<RECORD>> onMultipleRowsSelected = new Event();
    public final Event<SortingChangedEventData> onSortingChanged = new Event();
    public final Event<TableDataRequestEventData> onTableDataRequest = new Event();
    public final Event<FieldOrderChangeEventData> onFieldOrderChange = new Event();
    public final Event<ColumnSizeChangeEventData> onColumnSizeChange = new Event();
    private TableModel<RECORD> model = new ListTableModel(Collections.emptyList());
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private PropertyInjector<RECORD> propertyInjector = new BeanPropertyInjector();
    private final ClientRecordCache<RECORD, UiTableClientRecord> clientRecordCache;
    private int pageSize = 50;
    private RECORD selectedRecord;
    private final List<RECORD> selectedRecords = new ArrayList<RECORD>();
    private Map<RECORD, Map<String, Object>> transientChangesByRecordAndPropertyName = new HashMap<RECORD, Map<String, Object>>();
    private Map<RECORD, Map<String, List<FieldMessage>>> cellMessages = new HashMap<RECORD, Map<String, List<FieldMessage>>>();
    private Map<RECORD, Set<String>> markedCells = new HashMap<RECORD, Set<String>>();
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    private boolean displayAsList;
    private boolean forceFitWidth;
    private int rowHeight = 28;
    private boolean stripedRows = true;
    private boolean hideHeaders;
    private boolean allowMultiRowSelection = false;
    private boolean showRowCheckBoxes;
    private boolean showNumbering;
    private String sortField;
    private SortDirection sortDirection = SortDirection.ASC;
    private boolean editable;
    private boolean ensureEmptyLastRow;
    private boolean treeMode;
    private String indentedColumnName;
    private int indentation = 15;
    private SelectionFrame selectionFrame;
    private boolean showHeaderRow = false;
    private int headerRowHeight = 28;
    private Map<String, AbstractField> headerRowFields = new HashMap<String, AbstractField>(0);
    private boolean showFooterRow = false;
    private int footerRowHeight = 28;
    private Map<String, AbstractField> footerRowFields = new HashMap<String, AbstractField>(0);
    private EventListener<Void> onAllDataChangedListener = this::onAllDataChanged;
    private EventListener<RECORD> onRecordAddedListener = this::onRecordAdded;
    private EventListener<RECORD> onRecordDeletedListener = this::onRecordDeleted;
    private EventListener<RECORD> onRecordUpdatedListener = this::onRecordUpdated;
    private List<Integer> viewportDisplayedRecordClientIds;
    private TableCellCoordinates<RECORD> activeEditorCell;
    private List<RECORD> topNonModelRecords = new ArrayList<RECORD>();
    private List<RECORD> bottomNonModelRecords = new ArrayList<RECORD>();

    public Table() {
        this(new ArrayList<TableColumn>());
    }

    public Table(List<TableColumn> columns) {
        columns.forEach(this::addColumn);
        this.clientRecordCache = new ClientRecordCache<Object, UiTableClientRecord>(this::createUiTableClientRecord);
        this.clientRecordCache.setMaxCapacity(200);
        this.clientRecordCache.setPurgeDecider((record, clientId) -> this.viewportDisplayedRecordClientIds == null || !this.viewportDisplayedRecordClientIds.contains(clientId));
        this.clientRecordCache.setPurgeListener(purgedRecordIds -> {
            if (this.isRendered()) {
                this.getSessionContext().queueCommand(new UiTable.RemoveDataCommand(this.getId(), (List)purgedRecordIds.getResult()), aVoid -> purgedRecordIds.commit());
            } else {
                purgedRecordIds.commit();
            }
        });
    }

    public static <RECORD> Table<RECORD> create() {
        return new Table<RECORD>();
    }

    @Override
    protected void doDestroy() {
        this.unregisterModelEventListeners();
        this.headerRowFields.values().forEach(AbstractComponent::destroy);
        this.footerRowFields.values().forEach(AbstractComponent::destroy);
        this.columns.forEach(c -> c.getField().destroy());
    }

    public void addColumn(TableColumn column) {
        this.addColumn(column, this.columns.size());
    }

    public void addColumn(TableColumn column, int index) {
        this.addColumns(Collections.singletonList(column), index);
    }

    public void addColumns(List<TableColumn> newColumns, int index) {
        this.columns.addAll(index, newColumns);
        newColumns.forEach(column -> {
            column.setTable(this);
            AbstractField field = column.getField();
            field.setParent(this);
            field.onValueChanged.addListener(value -> {
                this.transientChangesByRecordAndPropertyName.computeIfAbsent(this.selectedRecord, idValue -> new HashMap()).put(column.getPropertyName(), value);
                this.onCellValueChanged.fire(new FieldValueChangedEventData<RECORD, Object>(this.selectedRecord, (TableColumn)column, value));
            });
        });
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiTable.AddColumnsCommand(this.getId(), newColumns.stream().map(c -> c.createUiTableColumn()).collect(Collectors.toList()), index), aVoid -> this.clientRecordCache.clear().commit());
        }
    }

    public void removeColumn(String propertyName) {
        this.columns.stream().filter(c -> Objects.equals(c.getPropertyName(), propertyName)).findFirst().ifPresent(this::removeColumn);
    }

    public void removeColumn(TableColumn column) {
        this.removeColumns(Collections.singletonList(column));
    }

    public void removeColumns(List<TableColumn> obsoleteColumns) {
        this.columns.removeAll(obsoleteColumns);
        if (this.isRendered()) {
            this.getSessionContext().queueCommand(new UiTable.RemoveColumnsCommand(this.getId(), obsoleteColumns.stream().map(c -> c.getPropertyName()).collect(Collectors.toList())), aVoid -> this.clientRecordCache.clear().commit());
        }
    }

    @Override
    public UiComponent createUiComponent() {
        List columns = this.columns.stream().map(tableColumn -> tableColumn.createUiTableColumn()).collect(Collectors.toList());
        UiTable uiTable = new UiTable(this.getId(), columns);
        this.mapAbstractUiComponentProperties((UiComponent)uiTable);
        uiTable.setSelectionFrame(this.selectionFrame != null ? this.selectionFrame.createUiSelectionFrame() : null);
        uiTable.setDisplayAsList(this.displayAsList);
        uiTable.setForceFitWidth(this.forceFitWidth);
        uiTable.setRowHeight(this.rowHeight);
        uiTable.setStripedRows(this.stripedRows);
        uiTable.setHideHeaders(this.hideHeaders);
        uiTable.setAllowMultiRowSelection(this.allowMultiRowSelection);
        uiTable.setShowRowCheckBoxes(this.showRowCheckBoxes);
        uiTable.setShowNumbering(this.showNumbering);
        List<RECORD> records = this.retrieveRecords(0, this.pageSize);
        CacheManipulationHandle<List<UiTableClientRecord>> cacheResponse = this.clientRecordCache.replaceRecords(records);
        cacheResponse.commit();
        uiTable.setTableData(cacheResponse.getResult());
        uiTable.setTotalNumberOfRecords(this.getTotalRecordsCount());
        uiTable.setSortField(this.sortField);
        uiTable.setSortDirection(this.sortDirection.toUiSortDirection());
        uiTable.setEditable(this.editable);
        uiTable.setTreeMode(this.treeMode);
        uiTable.setIndentedColumnName(this.indentedColumnName);
        uiTable.setIndentation(this.indentation);
        uiTable.setShowHeaderRow(this.showHeaderRow);
        uiTable.setHeaderRowHeight(this.headerRowHeight);
        uiTable.setHeaderRowFields(this.headerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiComponentReference())));
        uiTable.setShowFooterRow(this.showFooterRow);
        uiTable.setFooterRowHeight(this.footerRowHeight);
        uiTable.setFooterRowFields(this.footerRowFields.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AbstractField)e.getValue()).createUiComponentReference())));
        return uiTable;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TABLE_ROW_SELECTED: {
                UiTable.RowSelectedEvent rowSelectedEvent = (UiTable.RowSelectedEvent)event;
                this.selectedRecord = this.clientRecordCache.getRecordByClientId(rowSelectedEvent.getRecordId());
                this.selectedRecords.clear();
                this.onRowSelected.fire(this.selectedRecord);
                break;
            }
            case UI_TABLE_CELL_EDITING_STARTED: {
                UiTable.CellEditingStartedEvent editingStartedEvent = (UiTable.CellEditingStartedEvent)event;
                RECORD record = this.clientRecordCache.getRecordByClientId(editingStartedEvent.getRecordId());
                this.activeEditorCell = new TableCellCoordinates<RECORD>(record, editingStartedEvent.getColumnPropertyName());
                TableColumn column = this.getColumnByPropertyName(editingStartedEvent.getColumnPropertyName());
                Object cellValue = this.getCellValue(record, editingStartedEvent.getColumnPropertyName());
                AbstractField activeEditorField = this.getActiveEditorField();
                activeEditorField.setValue(cellValue);
                List<FieldMessage> cellMessages = this.getCellMessages(record, editingStartedEvent.getColumnPropertyName());
                List<FieldMessage> columnMessages = this.getColumnByPropertyName(editingStartedEvent.getColumnPropertyName()).getMessages();
                if (columnMessages == null) {
                    columnMessages = Collections.emptyList();
                }
                ArrayList<FieldMessage> messages = new ArrayList<FieldMessage>(cellMessages);
                messages.addAll(columnMessages);
                activeEditorField.setFieldMessages(messages);
                this.onCellEditingStarted.fire(new CellEditingStartedEvent<RECORD, Object>(this.clientRecordCache.getRecordByClientId(editingStartedEvent.getRecordId()), column, cellValue));
                break;
            }
            case UI_TABLE_CELL_EDITING_STOPPED: {
                this.activeEditorCell = null;
                UiTable.CellEditingStoppedEvent editingStoppedEvent = (UiTable.CellEditingStoppedEvent)event;
                TableColumn column = this.getColumnByPropertyName(editingStoppedEvent.getColumnPropertyName());
                this.onCellEditingStopped.fire(new CellEditingStoppedEvent<RECORD>(this.clientRecordCache.getRecordByClientId(editingStoppedEvent.getRecordId()), column));
                break;
            }
            case UI_TABLE_MULTIPLE_ROWS_SELECTED: {
                this.selectedRecord = null;
                UiTable.MultipleRowsSelectedEvent multipleRowsSelectedEvent = (UiTable.MultipleRowsSelectedEvent)event;
                this.selectedRecords.clear();
                this.selectedRecords.addAll(multipleRowsSelectedEvent.getRecordIds().stream().map(id -> this.clientRecordCache.getRecordByClientId((int)id)).collect(Collectors.toList()));
                this.onMultipleRowsSelected.fire(this.selectedRecords);
                break;
            }
            case UI_TABLE_SORTING_CHANGED: {
                UiTable.SortingChangedEvent sortingChangedEvent = (UiTable.SortingChangedEvent)event;
                this.sortField = sortingChangedEvent.getSortField();
                this.sortDirection = SortDirection.fromUiSortDirection(sortingChangedEvent.getSortDirection());
                this.onSortingChanged.fire(new SortingChangedEventData(sortingChangedEvent.getSortField(), SortDirection.fromUiSortDirection(sortingChangedEvent.getSortDirection())));
                this.refreshData(false, false, false);
                break;
            }
            case UI_TABLE_DISPLAYED_RANGE_CHANGED: {
                UiTable.DisplayedRangeChangedEvent rangeChangedEvent = (UiTable.DisplayedRangeChangedEvent)event;
                this.viewportDisplayedRecordClientIds = rangeChangedEvent.getDisplayedRecordIds();
                if (rangeChangedEvent.getDataRequest() == null) break;
                UiTableDataRequest dataRequest = rangeChangedEvent.getDataRequest();
                SortDirection sortDirection = SortDirection.fromUiSortDirection(dataRequest.getSortDirection());
                int startIndex = dataRequest.getStartIndex();
                int requestedLength = dataRequest.getLength();
                this.onTableDataRequest.fire(new TableDataRequestEventData(startIndex, requestedLength, dataRequest.getSortField(), sortDirection));
                int pagedStartIndex = startIndex - startIndex % this.pageSize;
                int endIndex = startIndex + requestedLength;
                int pagedEndIndex = endIndex % this.pageSize == 0 ? endIndex : endIndex + this.pageSize - endIndex % this.pageSize;
                this.sendDataToClient(pagedStartIndex, pagedEndIndex, false);
                break;
            }
            case UI_TABLE_REQUEST_NESTED_DATA: {
                UiTable.RequestNestedDataEvent nestedDataEvent = (UiTable.RequestNestedDataEvent)event;
                List<RECORD> childRecords = this.model.getChildRecords(this.clientRecordCache.getRecordByClientId(nestedDataEvent.getRecordId()), this.getSorting());
                CacheManipulationHandle<List<UiTableClientRecord>> cacheResponse = this.clientRecordCache.addRecords(childRecords);
                if (this.isRendered()) {
                    this.getSessionContext().queueCommand(new UiTable.SetChildrenDataCommand(this.getId(), nestedDataEvent.getRecordId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
                    break;
                }
                cacheResponse.commit();
                break;
            }
            case UI_TABLE_FIELD_ORDER_CHANGE: {
                UiTable.FieldOrderChangeEvent fieldOrderChangeEvent = (UiTable.FieldOrderChangeEvent)event;
                TableColumn column = this.getColumnByPropertyName(fieldOrderChangeEvent.getColumnPropertyName());
                this.onFieldOrderChange.fire(new FieldOrderChangeEventData(column, fieldOrderChangeEvent.getPosition()));
                break;
            }
            case UI_TABLE_COLUMN_SIZE_CHANGE: {
                UiTable.ColumnSizeChangeEvent columnSizeChangeEvent = (UiTable.ColumnSizeChangeEvent)event;
                TableColumn column = this.getColumnByPropertyName(columnSizeChangeEvent.getColumnPropertyName());
                this.onColumnSizeChange.fire(new ColumnSizeChangeEventData(column, columnSizeChangeEvent.getSize()));
                break;
            }
        }
    }

    private Object getCellValue(RECORD record, String columnPropertyName) {
        Map changesForRecord = this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap());
        boolean changed = changesForRecord.containsKey(columnPropertyName);
        Object cellValue = changed ? changesForRecord.get(columnPropertyName) : this.propertyExtractor.getValue(record, columnPropertyName);
        return cellValue;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(tableColumn -> tableColumn.getPropertyName()).collect(Collectors.toList());
    }

    public TableCellCoordinates<RECORD> getActiveEditorCell() {
        return this.activeEditorCell;
    }

    public AbstractField getActiveEditorField() {
        if (this.activeEditorCell != null) {
            return this.getColumnByPropertyName(this.activeEditorCell.getPropertyName()).getField();
        }
        return null;
    }

    public void setCellValue(RECORD record, String propertyName, Object value) {
        this.transientChangesByRecordAndPropertyName.computeIfAbsent(record, record1 -> new HashMap()).put(propertyName, value);
        Integer uiRecordIdOrNull = this.clientRecordCache.getUiRecordIdOrNull(record);
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.SetCellValueCommand(this.getId(), uiRecordIdOrNull.intValue(), propertyName, value));
        }
    }

    public void focusCell(RECORD record, String propertyName) {
    }

    public void setCellMarked(RECORD record, String propertyName, boolean mark) {
        if (mark) {
            this.markedCells.computeIfAbsent(record, record1 -> new HashSet()).add(propertyName);
        } else {
            Set markedCellPropertyNames = this.markedCells.getOrDefault(record, Collections.emptySet());
            if (markedCellPropertyNames.isEmpty()) {
                this.markedCells.remove(record);
            }
        }
        Integer uiRecordIdOrNull = this.clientRecordCache.getUiRecordIdOrNull(record);
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.MarkTableFieldCommand(this.getId(), uiRecordIdOrNull.intValue(), propertyName, mark));
        }
    }

    public void clearRecordMarkings(RECORD record) {
        this.markedCells.remove(record);
        this.updateRecordOnClientSide(record);
    }

    public void clearAllCellMarkings() {
        this.markedCells.clear();
        this.queueCommandIfRendered(() -> new UiTable.ClearAllFieldMarkingsCommand(this.getId()));
    }

    public void setRecordBold(RECORD record, boolean bold) {
        Integer uiRecordIdOrNull = this.clientRecordCache.getUiRecordIdOrNull(record);
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.SetRecordBoldCommand(this.getId(), uiRecordIdOrNull.intValue(), bold));
        }
    }

    public void selectSingleRow(RECORD record, boolean scrollToRecord) {
        this.selectedRecord = record;
        this.selectedRecords.clear();
        this.queueCommandIfRendered(() -> new UiTable.SelectRowsCommand(this.getId(), this.clientRecordCache.getUiRecordIds(this.getSelectedRecords()), scrollToRecord));
    }

    protected void updateColumnMessages(TableColumn tableColumn) {
        this.queueCommandIfRendered(() -> new UiTable.SetColumnMessagesCommand(this.getId(), tableColumn.getPropertyName(), tableColumn.getMessages().stream().map(message -> message.createUiFieldMessage()).collect(Collectors.toList())));
    }

    public List<FieldMessage> getCellMessages(RECORD record, String propertyName) {
        return this.cellMessages.getOrDefault(record, Collections.emptyMap()).getOrDefault(propertyName, Collections.emptyList());
    }

    public void addCellMessage(RECORD record, String propertyName, FieldMessage message) {
        List cellMessages = this.cellMessages.computeIfAbsent(record, x -> new HashMap()).computeIfAbsent(propertyName, x -> new ArrayList());
        cellMessages.add(message);
        this.updateSingleCellMessages(record, propertyName, cellMessages);
    }

    public void removeCellMessage(RECORD record, String propertyName, FieldMessage message) {
        List cellMessages = this.cellMessages.computeIfAbsent(record, x -> new HashMap()).computeIfAbsent(propertyName, x -> new ArrayList());
        cellMessages.remove(message);
        this.updateSingleCellMessages(record, propertyName, cellMessages);
    }

    private void updateSingleCellMessages(RECORD record, String propertyName, List<FieldMessage> cellMessages) {
        Integer uiRecordId = this.clientRecordCache.getUiRecordIdOrNull(record);
        if (uiRecordId != null) {
            this.queueCommandIfRendered(() -> new UiTable.SetSingleCellMessagesCommand(this.getId(), uiRecordId.intValue(), propertyName, cellMessages.stream().map(m -> m.createUiFieldMessage()).collect(Collectors.toList())));
        }
    }

    protected void updateColumnVisibility(TableColumn tableColumn) {
        this.queueCommandIfRendered(() -> new UiTable.SetColumnVisibilityCommand(this.getId(), tableColumn.getPropertyName(), tableColumn.isVisible()));
    }

    public void addNonModelRecord(RECORD record, boolean addToTop) {
        if (addToTop) {
            this.topNonModelRecords.add(0, record);
        } else {
            this.bottomNonModelRecords.add(record);
        }
        this.refreshData();
    }

    public void removeNonModelRecord(RECORD record) {
        this.topNonModelRecords.remove(record);
        this.bottomNonModelRecords.remove(record);
        this.refreshData();
    }

    public void removeAllNonModelRecords() {
        this.topNonModelRecords.clear();
        this.bottomNonModelRecords.clear();
        this.refreshData();
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel<RECORD> model) {
        this.unregisterModelEventListeners();
        this.model = model;
        this.clearChangeBuffer();
        model.onAllDataChanged().addListener(this.onAllDataChangedListener);
        model.onRecordAdded().addListener(this.onRecordAddedListener);
        model.onRecordDeleted().addListener(this.onRecordDeletedListener);
        model.onRecordUpdated().addListener(this.onRecordUpdatedListener);
        this.refreshData(true, true, true);
    }

    private void unregisterModelEventListeners() {
        if (this.model != null) {
            this.model.onAllDataChanged().removeListener(this.onAllDataChangedListener);
            this.model.onRecordAdded().removeListener(this.onRecordAddedListener);
            this.model.onRecordDeleted().removeListener(this.onRecordDeletedListener);
            this.model.onRecordUpdated().removeListener(this.onRecordUpdatedListener);
        }
    }

    private void onAllDataChanged(Void aVoid) {
        this.refreshData(true, false, true);
    }

    private void onRecordAdded(RECORD record) {
        if (this.isRendered()) {
            this.refreshData(false, false, false);
        }
    }

    private void onRecordDeleted(RECORD record) {
        this.clearMetaDataForRecord(record);
        if (Objects.equals(this.selectedRecord, record)) {
            this.selectedRecord = null;
        }
        if (this.selectedRecords != null) {
            this.selectedRecords.remove(record);
        }
        if (this.isRendered()) {
            CacheManipulationHandle<Integer> cacheResponse = this.clientRecordCache.removeRecord(record);
            this.getSessionContext().queueCommand(new UiTable.DeleteRowsCommand(this.getId(), Collections.singletonList(cacheResponse.getResult())), aVoid -> cacheResponse.commit());
        }
    }

    public void clearRecordMessages(RECORD record) {
        this.cellMessages.remove(record);
        this.updateRecordOnClientSide(record);
    }

    public void updateRecordMessages(RECORD record, Map<String, List<FieldMessage>> messages) {
        this.cellMessages.put(record, new HashMap<String, List<FieldMessage>>(messages));
        this.updateRecordOnClientSide(record);
    }

    private void clearMetaDataForRecord(RECORD record) {
        this.transientChangesByRecordAndPropertyName.remove(record);
        this.cellMessages.remove(record);
        this.markedCells.remove(record);
    }

    private void onRecordUpdated(RECORD record) {
        this.clearMetaDataForRecord(record);
        this.updateRecordOnClientSide(record);
    }

    private void updateRecordOnClientSide(RECORD record) {
        if (this.isRendered()) {
            CacheManipulationHandle<UiTableClientRecord> cacheResponse = this.clientRecordCache.addOrUpdateRecord(record);
            UiTableClientRecord clientRecord = cacheResponse.getResult();
            this.applyTransientChangesToClientRecord(clientRecord);
            this.getSessionContext().queueCommand(new UiTable.UpdateRecordCommand(this.getId(), clientRecord), aVoid -> cacheResponse.commit());
        }
    }

    public void refreshData() {
        this.refreshData(false, false, false);
    }

    private void refreshData(boolean resetMarkingsAndMessages, boolean resetSelection, boolean resetEditingState) {
        Integer editingClientRecordId;
        if (resetEditingState) {
            this.transientChangesByRecordAndPropertyName.clear();
        }
        if (resetMarkingsAndMessages) {
            this.cellMessages.clear();
            this.markedCells.clear();
        }
        if (resetSelection) {
            this.selectedRecord = null;
            this.selectedRecords.clear();
        }
        this.sendDataToClient(0, this.pageSize, true);
        if (!resetEditingState && this.activeEditorCell != null && (editingClientRecordId = this.clientRecordCache.getUiRecordIdOrNull(this.activeEditorCell.getRecord())) != null) {
            this.queueCommandIfRendered(() -> new UiTable.EditCellIfAvailableCommand(this.getId(), editingClientRecordId.intValue(), this.activeEditorCell.getPropertyName()));
        }
    }

    private void sendDataToClient(int startIndex, int endIndex, boolean clear) {
        if (startIndex == endIndex && !clear && this.topNonModelRecords.isEmpty() && this.bottomNonModelRecords.isEmpty()) {
            return;
        }
        if (this.isRendered()) {
            int totalCount = this.getTotalRecordsCount();
            List<RECORD> records = this.retrieveRecords(startIndex, endIndex - startIndex);
            CacheManipulationHandle<List<UiTableClientRecord>> cacheResponse = clear ? this.clientRecordCache.replaceRecords(records) : this.clientRecordCache.addRecords(records);
            if (!this.transientChangesByRecordAndPropertyName.isEmpty()) {
                cacheResponse.getResult().forEach(uiRecord -> this.applyTransientChangesToClientRecord((UiTableClientRecord)uiRecord));
            }
            UiTable.AddDataCommand addDataCommand = new UiTable.AddDataCommand(this.getId(), startIndex, cacheResponse.getResult(), totalCount, this.sortField, this.sortDirection.toUiSortDirection(), clear);
            LOGGER.debug("Sending table data to client: start: " + addDataCommand.getStartRowIndex() + "; length: " + addDataCommand.getData().size());
            this.getSessionContext().queueCommand(addDataCommand, aVoid -> cacheResponse.commit());
        }
    }

    private int getTotalRecordsCount() {
        return this.model.getCount() + this.topNonModelRecords.size() + this.bottomNonModelRecords.size();
    }

    private List<RECORD> retrieveRecords(int startIndex, int length) {
        int totalBottomRecords;
        int totalModelRecords;
        int endIndex = startIndex + length;
        int totalTopRecords = this.topNonModelRecords.size();
        if (endIndex > totalTopRecords + (totalModelRecords = this.model.getCount()) + (totalBottomRecords = this.bottomNonModelRecords.size())) {
            endIndex = totalTopRecords + totalModelRecords + totalBottomRecords;
            length = endIndex - startIndex;
        }
        if (startIndex < totalTopRecords && endIndex <= totalTopRecords) {
            return this.topNonModelRecords.subList(startIndex, endIndex);
        }
        if (startIndex < totalTopRecords && endIndex <= totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.topNonModelRecords.subList(startIndex, totalTopRecords));
            records.addAll(this.retrieveRecordsFromModel(0, length - (totalTopRecords - startIndex)));
            return records;
        }
        if (startIndex < totalTopRecords && endIndex > totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.topNonModelRecords.subList(startIndex, totalTopRecords));
            records.addAll(this.retrieveRecordsFromModel(0, totalModelRecords));
            records.addAll(this.bottomNonModelRecords.subList(0, length - (totalTopRecords - startIndex) - totalModelRecords));
            return records;
        }
        if (startIndex >= totalTopRecords && startIndex < totalTopRecords + totalModelRecords && endIndex <= totalTopRecords + totalModelRecords) {
            return this.retrieveRecordsFromModel(startIndex - this.topNonModelRecords.size(), length);
        }
        if (startIndex >= totalTopRecords && startIndex < totalTopRecords + totalModelRecords && endIndex > totalTopRecords + totalModelRecords) {
            ArrayList<RECORD> records = new ArrayList<RECORD>();
            records.addAll(this.retrieveRecordsFromModel(startIndex - this.topNonModelRecords.size(), endIndex - startIndex - totalTopRecords));
            records.addAll(this.bottomNonModelRecords.subList(0, endIndex - totalTopRecords - totalModelRecords));
            return records;
        }
        if (startIndex >= totalTopRecords + totalModelRecords) {
            return this.bottomNonModelRecords.subList(startIndex - totalTopRecords - totalModelRecords, endIndex - startIndex);
        }
        LOGGER.error("This path should never be reached!");
        return Collections.emptyList();
    }

    private List<RECORD> retrieveRecordsFromModel(int startIndex, int length) {
        List<RECORD> records = this.model.getRecords(startIndex, length, this.getSorting());
        if (records.size() == length) {
            return records;
        }
        if (records.size() < length) {
            LOGGER.warn("TableModel did not return the requested amount of data!");
            return records;
        }
        LOGGER.warn("TableModel returned to much data. Truncating!");
        return new ArrayList<RECORD>(records.subList(0, length));
    }

    private void applyTransientChangesToClientRecord(UiTableClientRecord uiRecord) {
        Map<String, Object> changes = this.transientChangesByRecordAndPropertyName.get(this.clientRecordCache.getRecordByClientId(uiRecord.getId()));
        if (changes != null) {
            changes.forEach((key, value) -> uiRecord.getValues().put(key, this.getColumnByPropertyName((String)key).getField().convertUxValueToUiValue(value)));
        }
    }

    public void cancelEditing() {
        TableCellCoordinates<RECORD> activeEditorCell = this.getActiveEditorCell();
        Integer uiRecordIdOrNull = this.clientRecordCache.getUiRecordIdOrNull(activeEditorCell.getRecord());
        if (uiRecordIdOrNull != null) {
            this.queueCommandIfRendered(() -> new UiTable.CancelEditingCellCommand(this.getId(), uiRecordIdOrNull.intValue(), activeEditorCell.getPropertyName()));
        }
    }

    @NotNull
    private Map<String, List<UiFieldMessage>> createUiFieldMessagesForRecord(Map<String, List<FieldMessage>> recordFieldMessages) {
        return recordFieldMessages.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().map(fieldMessage -> fieldMessage.createUiFieldMessage()).collect(Collectors.toList())));
    }

    private UiTableClientRecord createUiTableClientRecord(RECORD record) {
        UiTableClientRecord clientRecord = new UiTableClientRecord();
        HashMap<String, Object> uiValues = new HashMap<String, Object>();
        for (TableColumn column : this.columns) {
            Object uxValue = this.propertyExtractor.getValue(record, column.getPropertyName());
            uiValues.put(column.getPropertyName(), column.getField().convertUxValueToUiValue(uxValue));
        }
        clientRecord.setValues(uiValues);
        clientRecord.setSelected(this.selectedRecord != null && this.selectedRecord.equals(record) || this.selectedRecords.contains(record));
        clientRecord.setMessages(this.createUiFieldMessagesForRecord(this.cellMessages.getOrDefault(record, Collections.emptyMap())));
        clientRecord.setMarkings(new ArrayList(this.markedCells.getOrDefault(record, Collections.emptySet())));
        return clientRecord;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public boolean isDisplayAsList() {
        return this.displayAsList;
    }

    public void setDisplayAsList(boolean displayAsList) {
        this.displayAsList = displayAsList;
        this.reRenderIfRendered();
    }

    public boolean isForceFitWidth() {
        return this.forceFitWidth;
    }

    public void setForceFitWidth(boolean forceFitWidth) {
        this.forceFitWidth = forceFitWidth;
        this.reRenderIfRendered();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        this.reRenderIfRendered();
    }

    public boolean isStripedRows() {
        return this.stripedRows;
    }

    public void setStripedRows(boolean stripedRows) {
        this.stripedRows = stripedRows;
        this.reRenderIfRendered();
    }

    public void setStripedRowColorEven(Color stripedRowColorEven) {
        this.setCssStyle(".striped-rows .slick-row.even", "background-color", stripedRowColorEven != null ? stripedRowColorEven.toHtmlColorString() : null);
    }

    public void setStripedRowColorOdd(Color stripedRowColorOdd) {
        this.setCssStyle(".striped-rows .slick-row.odd", "background-color", stripedRowColorOdd != null ? stripedRowColorOdd.toHtmlColorString() : null);
    }

    public boolean isHideHeaders() {
        return this.hideHeaders;
    }

    public void setHideHeaders(boolean hideHeaders) {
        this.hideHeaders = hideHeaders;
        this.reRenderIfRendered();
    }

    public boolean isAllowMultiRowSelection() {
        return this.allowMultiRowSelection;
    }

    public void setAllowMultiRowSelection(boolean allowMultiRowSelection) {
        this.allowMultiRowSelection = allowMultiRowSelection;
        this.reRenderIfRendered();
    }

    public void setSelectionColor(Color selectionColor) {
        this.setCssStyle(".slick-cell.selected", "background-color", selectionColor != null ? selectionColor.toHtmlColorString() : null);
    }

    public void setRowBorderWidth(int rowBorderWidth) {
        this.setCssStyle(".slick-cell", "border-bottom-width", rowBorderWidth + "px");
    }

    public void setRowBorderColor(Color rowBorderColor) {
        this.setCssStyle(".slick-cell", "border-color", rowBorderColor.toHtmlColorString());
    }

    public boolean isShowRowCheckBoxes() {
        return this.showRowCheckBoxes;
    }

    public void setShowRowCheckBoxes(boolean showRowCheckBoxes) {
        this.showRowCheckBoxes = showRowCheckBoxes;
        this.reRenderIfRendered();
    }

    public boolean isShowNumbering() {
        return this.showNumbering;
    }

    public void setShowNumbering(boolean showNumbering) {
        this.showNumbering = showNumbering;
        this.reRenderIfRendered();
    }

    public Sorting getSorting() {
        return new Sorting(this.sortField, this.sortDirection);
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
        this.refreshData(false, false, false);
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
        this.refreshData(false, false, false);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.reRenderIfRendered();
    }

    public boolean isEnsureEmptyLastRow() {
        return this.ensureEmptyLastRow;
    }

    public void setEnsureEmptyLastRow(boolean ensureEmptyLastRow) {
        this.ensureEmptyLastRow = ensureEmptyLastRow;
        this.reRenderIfRendered();
    }

    public boolean isTreeMode() {
        return this.treeMode;
    }

    public void setTreeMode(boolean treeMode) {
        this.treeMode = treeMode;
        this.reRenderIfRendered();
    }

    public String getIndentedColumnName() {
        return this.indentedColumnName;
    }

    public void setIndentedColumnName(String indentedColumnName) {
        this.indentedColumnName = indentedColumnName;
        this.reRenderIfRendered();
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
        this.reRenderIfRendered();
    }

    public SelectionFrame getSelectionFrame() {
        return this.selectionFrame;
    }

    public void setSelectionFrame(SelectionFrame selectionFrame) {
        this.selectionFrame = selectionFrame;
        this.reRenderIfRendered();
    }

    public boolean isShowHeaderRow() {
        return this.showHeaderRow;
    }

    public void setShowHeaderRow(boolean showHeaderRow) {
        this.showHeaderRow = showHeaderRow;
        this.reRenderIfRendered();
    }

    public void setHeaderRowBorderWidth(int headerRowBorderWidth) {
        this.setCssStyle(".slick-headerrow", "border-bottom-width", headerRowBorderWidth + "px");
    }

    public void setHeaderRowBorderColor(Color headerRowBorderColor) {
        this.setCssStyle(".slick-headerrow", "border-bottom-color", headerRowBorderColor != null ? headerRowBorderColor.toHtmlColorString() : null);
    }

    public int getHeaderRowHeight() {
        return this.headerRowHeight;
    }

    public void setHeaderRowHeight(int headerRowHeight) {
        this.headerRowHeight = headerRowHeight;
        this.reRenderIfRendered();
    }

    public void setHeaderRowBackgroundColor(Color headerRowBackgroundColor) {
        this.setCssStyle(".slick-headerrow", "background-color", headerRowBackgroundColor != null ? headerRowBackgroundColor.toHtmlColorString() : null);
    }

    public Map<String, AbstractField> getHeaderRowFields() {
        return Collections.unmodifiableMap(this.headerRowFields);
    }

    public void setHeaderRowFields(Map<String, AbstractField> headerRowFields) {
        this.headerRowFields.clear();
        this.headerRowFields.putAll(headerRowFields);
        this.headerRowFields.values().forEach(field -> field.setParent(this));
        this.reRenderIfRendered();
    }

    public void setHeaderRowField(String columnName, AbstractField field) {
        this.headerRowFields.put(columnName, field);
    }

    public boolean isShowFooterRow() {
        return this.showFooterRow;
    }

    public void setShowFooterRow(boolean showFooterRow) {
        this.showFooterRow = showFooterRow;
        this.reRenderIfRendered();
    }

    public void setFooterRowBorderWidth(int footerRowBorderWidth) {
        this.setCssStyle(".slick-footerrow", "border-top-width", footerRowBorderWidth + "px");
    }

    public void setFooterRowBorderColor(Color footerRowBorderColor) {
        this.setCssStyle(".slick-footerrow", "border-top-color", footerRowBorderColor != null ? footerRowBorderColor.toHtmlColorString() : null);
    }

    public int getFooterRowHeight() {
        return this.footerRowHeight;
    }

    public void setFooterRowHeight(int footerRowHeight) {
        this.footerRowHeight = footerRowHeight;
        this.reRenderIfRendered();
    }

    public void setFooterRowBackgroundColor(Color footerRowBackgroundColor) {
        this.setCssStyle(".slick-footerrow", "background-color", footerRowBackgroundColor != null ? footerRowBackgroundColor.toHtmlColorString() : null);
    }

    public Map<String, AbstractField> getFooterRowFields() {
        return this.footerRowFields;
    }

    public void setFooterRowFields(Map<String, AbstractField> footerRowFields) {
        this.footerRowFields.clear();
        this.footerRowFields.putAll(footerRowFields);
        this.headerRowFields.values().forEach(field -> field.setParent(this));
        this.reRenderIfRendered();
    }

    public void setFooterRowField(String columnName, AbstractField field) {
        this.footerRowFields.put(columnName, field);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public TableColumn getColumnByPropertyName(String propertyName) {
        return this.columns.stream().filter(column -> column.getPropertyName().equals(propertyName)).findFirst().orElse(null);
    }

    public AbstractField getHeaderRowFieldByName(String propertyName) {
        return this.headerRowFields.get(propertyName);
    }

    public AbstractField getFooterRowFieldByName(String propertyName) {
        return this.footerRowFields.get(propertyName);
    }

    public List<RECORD> getRecordsWithChangedCellValues() {
        return new ArrayList<RECORD>(this.transientChangesByRecordAndPropertyName.keySet());
    }

    public Map<String, Object> getChangedCellValues(RECORD record) {
        return this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap());
    }

    public Map<String, Object> getAllCellValues(RECORD record) {
        Map<String, Object> values = this.propertyExtractor.getValues(record, this.columns.stream().map(c -> c.getPropertyName()).collect(Collectors.toList()));
        values.putAll(this.transientChangesByRecordAndPropertyName.getOrDefault(record, Collections.emptyMap()));
        return values;
    }

    public void clearChangeBuffer() {
        this.transientChangesByRecordAndPropertyName.clear();
    }

    public void applyCellValuesToRecord(RECORD record) {
        Map<String, Object> changedCellValues = this.getChangedCellValues(record);
        this.propertyInjector.setValues(record, changedCellValues);
    }

    public void revertChanges() {
        this.refreshData(true, false, true);
    }

    public RECORD getSelectedRecord() {
        return this.selectedRecord;
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public PropertyInjector<RECORD> getPropertyInjector() {
        return this.propertyInjector;
    }

    public void setPropertyInjector(PropertyInjector<RECORD> propertyInjector) {
        this.propertyInjector = propertyInjector;
    }

    public void setMaxCacheCapacity(int maxCapacity) {
        this.clientRecordCache.setMaxCapacity(maxCapacity);
    }

    public int getMaxCacheCapacity() {
        return this.clientRecordCache.getMaxCapacity();
    }

    public List<RECORD> getSelectedRecords() {
        return this.selectedRecords != null ? this.selectedRecords : (this.selectedRecord != null ? Collections.singletonList(this.selectedRecord) : Collections.emptyList());
    }
}

