/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.resource;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.resource.ResourceProvider;

public class ClassPathResourceProvider
implements ResourceProvider {
    private final String basePackage;

    public ClassPathResourceProvider(String basePackage) {
        this.basePackage = ClassPathResourceProvider.normalizeClassPathResourcePath(basePackage);
    }

    @Override
    public Resource getResource(String servletPath, String relativeResourcePath, String sessionId) {
        return new ClassPathResource(this.getJavaResourceName(relativeResourcePath));
    }

    private String getJavaResourceName(String resource) {
        return this.basePackage + resource;
    }

    @VisibleForTesting
    static String normalizeClassPathResourcePath(String basePackage) {
        if (!((String)basePackage).contains("/") && ((String)basePackage).contains(".")) {
            basePackage = ((String)basePackage).replaceAll("\\.", "/");
        }
        if (!((String)basePackage).startsWith("/")) {
            basePackage = "/" + (String)basePackage;
        }
        if (((String)basePackage).endsWith("/")) {
            basePackage = ((String)basePackage).substring(0, ((String)basePackage).length() - 1);
        }
        return basePackage;
    }

    private class ClassPathResource
    implements Resource {
        private final String resourceName;
        private Long cachedSize;

        public ClassPathResource(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public InputStream getInputStream() {
            return this.getClass().getResourceAsStream(this.resourceName);
        }

        @Override
        public long getLength() {
            if (this.cachedSize == null) {
                this.cachedSize = Resource.super.getLength();
            }
            return this.cachedSize;
        }
    }
}

