/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.session;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.ux.resource.FileResource;
import org.teamapps.ux.resource.Resource;

public class ClientSessionResourceProvider {
    public static final String BASE_PATH = "/files/";
    private QualifiedUiSessionId sessionId;
    private AtomicInteger idGenerator = new AtomicInteger();
    private Map<Integer, Resource> binaryResourceById = new HashMap<Integer, Resource>();
    private Map<File, String> fileLinkByFile = new HashMap<File, String>();
    private Map<String, String> resourceLinkByUniqueIdentifier = new HashMap<String, String>();

    public ClientSessionResourceProvider(QualifiedUiSessionId sessionId) {
        this.sessionId = sessionId;
    }

    public Resource getBinaryResource(int resourceId) {
        return this.binaryResourceById.get(resourceId);
    }

    public String createFileLink(File file) {
        if (file == null) {
            return null;
        }
        if (this.fileLinkByFile.containsKey(file)) {
            return this.fileLinkByFile.get(file);
        }
        FileResource resource = new FileResource(file);
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String fileLink = this.createLink(id);
        this.fileLinkByFile.put(file, fileLink);
        return fileLink;
    }

    public String createResourceLink(final Supplier<InputStream> inputStreamSupplier, final long length, final String resourceName, String uniqueIdentifier) {
        if (inputStreamSupplier == null) {
            return null;
        }
        if (uniqueIdentifier != null && this.resourceLinkByUniqueIdentifier.containsKey(uniqueIdentifier)) {
            return this.resourceLinkByUniqueIdentifier.get(uniqueIdentifier);
        }
        Resource resource = new Resource(){

            @Override
            public InputStream getInputStream() {
                return (InputStream)inputStreamSupplier.get();
            }

            @Override
            public long getLength() {
                return length;
            }

            @Override
            public Date getLastModified() {
                return new Date();
            }

            @Override
            public Date getExpires() {
                return new Date(System.currentTimeMillis() + 600000000L);
            }

            @Override
            public String getName() {
                return resourceName;
            }

            @Override
            public String getMimeType() {
                return null;
            }
        };
        int id = this.createId();
        this.binaryResourceById.put(id, resource);
        String resourceLink = this.createLink(id);
        if (uniqueIdentifier != null) {
            this.resourceLinkByUniqueIdentifier.put(uniqueIdentifier, resourceLink);
        }
        return resourceLink;
    }

    private int createId() {
        return this.idGenerator.incrementAndGet();
    }

    private String createLink(int id) {
        return BASE_PATH + this.sessionId.getUiSessionId() + "/res" + id;
    }
}

