/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.webcontroller;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.teamapps.icon.material.MaterialIconProvider;
import org.teamapps.icons.api.IconStyle;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.UxServerContext;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;

public interface WebController {
    public void onSessionStart(SessionContext var1);

    default public Collection<ServletRegistration> getServletRegistrations(UxServerContext serverContext) {
        return Collections.emptyList();
    }

    default public IconTheme getDefaultIconTheme(boolean isMobile) {
        IconProvider iconProvider = this.getIconProvider();
        if (isMobile) {
            return IconTheme.of((IconStyle)iconProvider.getDefaultMobileStyle(), (IconStyle)iconProvider.getDefaultSubIconStyle());
        }
        return IconTheme.of((IconStyle)iconProvider.getDefaultDesktopStyle(), (IconStyle)iconProvider.getDefaultSubIconStyle());
    }

    default public IconProvider getIconProvider() {
        return new MaterialIconProvider();
    }

    default public List<IconProvider> getAdditionalIconProvider() {
        return null;
    }

    default public void destroy() {
    }

    default public SessionConfiguration createSessionConfiguration(SessionContext context) {
        boolean optimizedForTouch = false;
        StylingTheme theme = StylingTheme.DEFAULT;
        if (context.getClientInfo().isMobileDevice()) {
            optimizedForTouch = true;
            theme = StylingTheme.MODERN;
        }
        return SessionConfiguration.create(Locale.forLanguageTag(context.getClientInfo().getPreferredLanguageIso()), ZoneId.of(context.getClientInfo().getTimeZone()), theme, optimizedForTouch);
    }
}

