/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.dto.UiComponentField;
import org.teamapps.dto.UiField;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;

public class ComponentField
extends AbstractField<Void> {
    private Component component;
    private int height;
    private boolean bordered = true;

    public ComponentField(Component component) {
        this(component, 0);
    }

    public ComponentField(Component component, int height) {
        this.component = component;
        this.height = height;
    }

    public UiField createUiComponent() {
        UiComponentField uiField = new UiComponentField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiField);
        uiField.setComponent(Component.createUiClientObjectReference(this.component));
        uiField.setHeight(this.height);
        uiField.setBordered(this.bordered);
        return uiField;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.queueCommandIfRendered(() -> new UiComponentField.SetComponentCommand(this.getId(), Component.createUiClientObjectReference(component)));
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiComponentField.SetHeightCommand(this.getId(), height));
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
        this.queueCommandIfRendered(() -> new UiComponentField.SetBorderedCommand(this.getId(), bordered));
    }
}

