/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field.datetime;

import java.time.Instant;
import java.time.ZoneId;
import org.teamapps.dto.AbstractUiDateTimeField;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiInstantDateTimeField;
import org.teamapps.ux.component.field.datetime.AbstractDateTimeField;

public class InstantDateTimeField
extends AbstractDateTimeField<Instant> {
    protected ZoneId timeZoneId = this.getSessionContext().getTimeZone();

    public UiField createUiComponent() {
        UiInstantDateTimeField uiField = new UiInstantDateTimeField();
        this.mapAbstractDateTimeFieldUiValues((AbstractUiDateTimeField)uiField);
        uiField.setTimeZoneId(this.timeZoneId.getId());
        return uiField;
    }

    public ZoneId getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = timeZoneId;
        this.queueCommandIfRendered(() -> new UiInstantDateTimeField.SetTimeZoneIdCommand(this.getId(), timeZoneId.getId()));
    }

    @Override
    public Instant convertUiValueToUxValue(Object value) {
        if (value == null) {
            return null;
        }
        return Instant.ofEpochMilli(((Number)value).longValue());
    }
}

