/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.uisession;

public class ClientBackPressureInfo {
    private final int maxCommandBufferSize;
    private final int unconsumedCommandsCount;
    private final int minRequestedCommands;
    private final int maxRequestedCommands;
    private final int remainingRequestedCommands;
    private final long requestedCommandsZeroReachingTimestamp;

    public ClientBackPressureInfo(int maxCommandBufferSize, int unconsumedCommandsCount, int minRequestedCommands, int maxRequestedCommands, int remainingRequestedCommands, long requestedCommandsZeroReachingTimestamp) {
        this.maxCommandBufferSize = maxCommandBufferSize;
        this.unconsumedCommandsCount = unconsumedCommandsCount;
        this.minRequestedCommands = minRequestedCommands;
        this.maxRequestedCommands = maxRequestedCommands;
        this.remainingRequestedCommands = remainingRequestedCommands;
        this.requestedCommandsZeroReachingTimestamp = requestedCommandsZeroReachingTimestamp;
    }

    public boolean isBusy() {
        boolean clientNotRequestingMoreCommands = this.requestedCommandsZeroReachingTimestamp > 0L && this.requestedCommandsZeroReachingTimestamp < System.currentTimeMillis() - 500L;
        boolean commandBufferCriticallyFull = this.unconsumedCommandsCount > 500;
        return clientNotRequestingMoreCommands || commandBufferCriticallyFull;
    }

    public int getMaxCommandBufferSize() {
        return this.maxCommandBufferSize;
    }

    public int getUnconsumedCommandsCount() {
        return this.unconsumedCommandsCount;
    }

    public int getMinRequestedCommands() {
        return this.minRequestedCommands;
    }

    public int getMaxRequestedCommands() {
        return this.maxRequestedCommands;
    }

    public int getRemainingRequestedCommands() {
        return this.remainingRequestedCommands;
    }

    public long getRequestedCommandsZeroReachingTimestamp() {
        return this.requestedCommandsZeroReachingTimestamp;
    }

    public String toString() {
        return "ClientBackPressureInfo{maxCommandBufferSize=" + this.maxCommandBufferSize + ", commandBufferFillSize=" + this.unconsumedCommandsCount + ", minRequestedCommands=" + this.minRequestedCommands + ", maxRequestedCommands=" + this.maxRequestedCommands + ", remainingRequestedCommands=" + this.remainingRequestedCommands + ", requestedCommandsBelowMinTimestamp=" + this.requestedCommandsZeroReachingTimestamp + ", timeSinceLastCommandRequestAfterZero=" + (System.currentTimeMillis() - this.requestedCommandsZeroReachingTimestamp) + "}";
    }
}

