/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiTemplate;
import org.teamapps.ux.component.format.FontStyle;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.gridtemplate.AbstractTemplateElement;
import org.teamapps.ux.component.template.gridtemplate.FloatingElement;
import org.teamapps.ux.component.template.gridtemplate.GridTemplate;
import org.teamapps.ux.component.template.gridtemplate.TextElement;

public interface Template {
    public UiTemplate createUiTemplate();

    public List<String> getPropertyNames();

    public static Map<String, UiTemplate> createUiTemplates(Map<String, ? extends Template> templates) {
        return templates.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((Template)entry.getValue()).createUiTemplate()));
    }

    default public Template createDarkThemeTemplate() {
        if (this instanceof BaseTemplate) {
            BaseTemplate baseTemplate = (BaseTemplate)this;
            return baseTemplate.getTemplate().createDarkThemeTemplate();
        }
        if (this instanceof GridTemplate) {
            GridTemplate orig = (GridTemplate)this;
            GridTemplate tpl = new GridTemplate(orig.getMinWidth(), orig.getMaxWidth(), orig.getMinHeight(), orig.getMaxHeight(), orig.getPadding(), orig.getGridGap());
            tpl.setRows(orig.getRows());
            tpl.setColumns(orig.getColumns());
            ArrayList darkModeElements = new ArrayList();
            orig.getElements().forEach(element -> {
                if (element instanceof FloatingElement) {
                    FloatingElement floatingElement = (FloatingElement)element;
                    List<AbstractTemplateElement<?>> elements = floatingElement.getElements();
                    ArrayList newElements = new ArrayList();
                    for (AbstractTemplateElement<?> fltElement : elements) {
                        newElements.add(Template.convertElementToDarkMode(fltElement));
                    }
                    FloatingElement newFloatingElement = new FloatingElement(floatingElement.getRow(), floatingElement.getColumn()).setElements(newElements);
                    darkModeElements.add(newFloatingElement);
                } else {
                    darkModeElements.add(Template.convertElementToDarkMode(element));
                }
            });
            tpl.setElements(darkModeElements);
            return tpl;
        }
        return this;
    }

    public static AbstractTemplateElement<?> convertElementToDarkMode(AbstractTemplateElement<?> element) {
        if (element instanceof TextElement) {
            TextElement txt = (TextElement)element;
            TextElement newTextElement = new TextElement(txt.getProperty(), txt.getRow(), txt.getColumn(), txt.getRowSpan(), txt.getColSpan(), txt.getHorizontalAlignment(), txt.getVerticalAlignment());
            newTextElement.setPadding(txt.getPadding());
            newTextElement.setMargin(txt.getMargin());
            newTextElement.setTextAlignment(txt.getTextAlignment());
            newTextElement.setLineHeight(txt.getLineHeight());
            FontStyle style = txt.getFontStyle();
            if (style == null) {
                FontStyle newFontStyle = new FontStyle();
                newTextElement.setFontStyle(newFontStyle);
                return newTextElement;
            }
            Color fontColor = style.getFontColor();
            Object newColor = RgbaColor.WHITE;
            newColor = fontColor != null ? Template.convertColorToDarkMode(fontColor) : null;
            FontStyle newFontStyle = new FontStyle(style.getRelativeFontSize(), (Color)newColor, style.getBackgroundColor(), style.isBold(), style.isUnderline(), style.isItalic());
            newTextElement.setFontStyle(newFontStyle);
            return newTextElement;
        }
        return element;
    }

    public static Color convertColorToDarkMode(Color color) {
        if (color.equals(RgbaColor.BLACK)) {
            return RgbaColor.WHITE;
        }
        if (color.equals(RgbaColor.WHITE)) {
            // empty if block
        }
        if (color.equals(RgbaColor.GRAY)) {
            return RgbaColor.LIGHT_GRAY;
        }
        return RgbaColor.WHITE;
    }
}

