/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.template.htmltemplate;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.teamapps.dto.UiMustacheTemplate;
import org.teamapps.dto.UiTemplate;
import org.teamapps.ux.component.template.Template;

public class MustacheTemplate
implements Template {
    private static final Pattern PLACE_HOLDER_REGEX = Pattern.compile("\\{\\{#?(\\w+)\\}\\}");
    private final String templateString;
    private final List<String> propertyNames;

    public MustacheTemplate(String templateString) {
        this.templateString = templateString;
        this.propertyNames = PLACE_HOLDER_REGEX.matcher(this.templateString).results().map(matchResult -> matchResult.group(1)).collect(Collectors.toList());
    }

    @Override
    public UiTemplate createUiTemplate() {
        return new UiMustacheTemplate(this.templateString);
    }

    @Override
    public List<String> getPropertyNames() {
        return this.propertyNames;
    }
}

