/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.event;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.event.Disposable;
import org.teamapps.event.SelfDisposingEventListener;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class Event<EVENT_DATA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Event.class);
    private final String source;
    private final List<Consumer<EVENT_DATA>> listeners = new CopyOnWriteArrayList<Consumer<EVENT_DATA>>();
    private EVENT_DATA lastEventData;

    public Event() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
        this.source = stackTraceElement.getFileName() + stackTraceElement.getLineNumber();
    }

    public Disposable addListener(Consumer<EVENT_DATA> listener) {
        return this.addListener(listener, true);
    }

    public Disposable addListener(Consumer<EVENT_DATA> listener, boolean bindToSessionContext) {
        SessionContext currentSessionContext;
        if (bindToSessionContext && (currentSessionContext = CurrentSessionContext.getOrNull()) != null) {
            this.listeners.add(new SessionContextAwareEventListener<EVENT_DATA>(currentSessionContext, listener));
            this.removeWhenSessionDestroyed(listener, currentSessionContext);
        } else {
            this.listeners.add(listener);
        }
        return () -> this.removeListener(listener);
    }

    public Disposable addListener(SelfDisposingEventListener<EVENT_DATA> listener) {
        return this.addListener(listener, true);
    }

    public Disposable addListener(SelfDisposingEventListener<EVENT_DATA> listener, boolean bindToSessionContext) {
        AtomicReference<Disposable> disposable = new AtomicReference<Disposable>();
        disposable.set(this.addListener((EVENT_DATA e) -> listener.handle(e, (Disposable)disposable.get()), bindToSessionContext));
        return (Disposable)disposable.get();
    }

    public Disposable addListener(Runnable listener) {
        return this.addListener(listener, true);
    }

    public Disposable addListener(Runnable listener, boolean bindToSessionContext) {
        return this.addListener(new RunnableWrapper(listener), bindToSessionContext);
    }

    List<Consumer<EVENT_DATA>> getListeners() {
        return this.listeners;
    }

    @Deprecated
    public void removeListener(Runnable listener) {
        this.removeListener(new RunnableWrapper(listener));
    }

    @Deprecated
    public void removeListener(Consumer<EVENT_DATA> listener) {
        this.listeners.remove(listener);
        this.listeners.remove(new SessionContextAwareEventListener<EVENT_DATA>(listener));
    }

    private void removeWhenSessionDestroyed(Consumer<EVENT_DATA> listener, SessionContext currentSessionContext) {
        if (this != currentSessionContext.onDestroyed()) {
            WeakReference<Consumer<EVENT_DATA>> listenerWeakReference = new WeakReference<Consumer<EVENT_DATA>>(listener);
            currentSessionContext.onDestroyed().listeners.add(aVoid -> {
                Consumer l = (Consumer)listenerWeakReference.get();
                if (l != null) {
                    this.removeListener(l);
                }
            });
        }
    }

    public void fire(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (Consumer<EVENT_DATA> listener : this.listeners) {
            this.invokeListener(eventData, listener);
        }
    }

    public void fireIgnoringExceptions(EVENT_DATA eventData) {
        this.lastEventData = eventData;
        for (Consumer<EVENT_DATA> listener : this.listeners) {
            try {
                this.invokeListener(eventData, listener);
            }
            catch (Exception e) {
                LOGGER.error("Error while calling event handler. Ignoring exception.", (Throwable)e);
            }
        }
    }

    protected void invokeListener(EVENT_DATA eventData, Consumer<EVENT_DATA> listener) {
        listener.accept(eventData);
    }

    public void fire() {
        this.fire(null);
    }

    public void fireIfChanged(EVENT_DATA eventData) {
        if (!Objects.equals(this.lastEventData, eventData)) {
            this.fire(eventData);
        }
    }

    public <T> Event<T> converted(Function<EVENT_DATA, T> converter) {
        Event newEvent = new Event();
        this.addListener((EVENT_DATA data) -> newEvent.fire(converter.apply(data)));
        return newEvent;
    }

    private static class RunnableWrapper<T>
    implements Consumer<T> {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void accept(T eventData) {
            this.runnable.run();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunnableWrapper that = (RunnableWrapper)o;
            return this.runnable.equals(that.runnable);
        }

        public int hashCode() {
            return Objects.hash(this.runnable);
        }
    }

    private static class SessionContextAwareEventListener<EVENT_DATA>
    implements Consumer<EVENT_DATA> {
        private final SessionContext sessionContext;
        private final Consumer<EVENT_DATA> delegate;

        public SessionContextAwareEventListener(SessionContext sessionContext, Consumer<EVENT_DATA> delegate) {
            this.sessionContext = sessionContext;
            this.delegate = delegate;
        }

        public SessionContextAwareEventListener(Consumer<EVENT_DATA> delegate) {
            this(null, delegate);
        }

        @Override
        public void accept(EVENT_DATA eventData) {
            if (this.sessionContext != null) {
                this.sessionContext.runWithContext(() -> this.delegate.accept(eventData));
            } else {
                this.delegate.accept(eventData);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionContextAwareEventListener that = (SessionContextAwareEventListener)o;
            return this.delegate != null ? this.delegate.equals(that.delegate) : that.delegate == null;
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }
}

