/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.absolutelayout;

import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.absolutelayout.SizeUnit;

public class AbsolutePosition {
    private final Length top;
    private final Length right;
    private final Length bottom;
    private final Length left;
    private final Length width;
    private final Length height;
    private final int zIndex;

    public AbsolutePosition(Length top, Length right, Length bottom, Length left, Length width, Length height, int zIndex) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
        this.width = width;
        this.height = height;
        this.zIndex = zIndex;
    }

    public static AbsolutePosition fromPixelTopRightBottomLeft(float top, float right, float bottom, float left, int zIndex) {
        return new AbsolutePosition(new Length(top), new Length(right), new Length(bottom), new Length(left), null, null, zIndex);
    }

    public static AbsolutePosition fromRelativeTopRightBottomLeft(float top, float right, float bottom, float left, int zIndex) {
        return new AbsolutePosition(new Length(top, SizeUnit.PERCENT), new Length(right, SizeUnit.PERCENT), new Length(bottom, SizeUnit.PERCENT), new Length(left, SizeUnit.PERCENT), null, null, zIndex);
    }

    public static AbsolutePosition fromRelativeDimensions(float top, float left, float width, float height, int zIndex) {
        return new AbsolutePosition(new Length(top, SizeUnit.PERCENT), null, null, new Length(left, SizeUnit.PERCENT), new Length(width, SizeUnit.PERCENT), new Length(height, SizeUnit.PERCENT), zIndex);
    }

    public static AbsolutePosition fromRelativeRightBottomDimensions(float right, float bottom, float width, float height, int zIndex) {
        return new AbsolutePosition(null, new Length(right, SizeUnit.PERCENT), new Length(bottom, SizeUnit.PERCENT), null, new Length(width, SizeUnit.PERCENT), new Length(height, SizeUnit.PERCENT), zIndex);
    }

    public static AbsolutePosition fromPixelDimensions(Length top, Length left, Length width, Length height, int zIndex) {
        return new AbsolutePosition(top, null, null, left, width, height, zIndex);
    }

    public static AbsolutePosition fullSizeAsRelativeDimensions(int zIndex) {
        return AbsolutePosition.fromRelativeDimensions(0.0f, 0.0f, 100.0f, 100.0f, 0);
    }

    public Length getTop() {
        return this.top;
    }

    public Length getRight() {
        return this.right;
    }

    public Length getBottom() {
        return this.bottom;
    }

    public Length getLeft() {
        return this.left;
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getHeight() {
        return this.height;
    }

    public int getZIndex() {
        return this.zIndex;
    }
}

