/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.cache;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.template.Template;

public class ClientTemplateCache<RECORD> {
    private final Listener listener;
    private final Map<Template, Integer> templateIdsByTemplate = new HashMap<Template, Integer>();
    private int templateIdCounter = 0;
    private Template defaultTemplate;
    private TemplateDecider<RECORD> templateDecider = record -> this.defaultTemplate;

    public ClientTemplateCache(Template defaultTemplate, Listener listener) {
        this.defaultTemplate = defaultTemplate;
        this.listener = listener;
    }

    public ClientTemplateCache(Listener listener) {
        this.listener = listener;
    }

    public TemplateWithClientId getTemplateIdForRecord(RECORD record) {
        return this.getTemplateIdForRecord(record, null);
    }

    public TemplateWithClientId getTemplateIdForRecord(RECORD record, Template defaultTemplate) {
        Template template;
        Template templateFromDecider = this.templateDecider.getTemplate(record);
        Template template2 = templateFromDecider != null ? templateFromDecider : (template = defaultTemplate != null ? defaultTemplate : this.defaultTemplate);
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            int id = ++this.templateIdCounter;
            this.templateIdsByTemplate.put(template, id);
            this.listener.onNewTemplate(id, template);
        }
        Integer clientId = template != null ? this.templateIdsByTemplate.get(template) : null;
        return new TemplateWithClientId(template, clientId);
    }

    public Template getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(Template defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public TemplateDecider<RECORD> getTemplateDecider() {
        return this.templateDecider;
    }

    public void setTemplateDecider(TemplateDecider<RECORD> templateDecider) {
        this.templateDecider = templateDecider;
    }

    public static class TemplateWithClientId {
        private Template template;
        private Integer clientId;

        public TemplateWithClientId(Template template, Integer clientId) {
            this.template = template;
            this.clientId = clientId;
        }

        public Template getTemplate() {
            return this.template;
        }

        public void setTemplate(Template template) {
            this.template = template;
        }

        public Integer getClientId() {
            return this.clientId;
        }

        public void setClientId(Integer clientId) {
            this.clientId = clientId;
        }
    }

    public static interface Listener {
        public void onNewTemplate(int var1, Template var2);
    }
}

