/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiIdentifiableClientRecord;
import org.teamapps.dto.UiInfiniteItemView2;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemViewModel;
import org.teamapps.ux.component.infiniteitemview.ItemClickedEventData;
import org.teamapps.ux.component.infiniteitemview.ItemRange;
import org.teamapps.ux.component.infiniteitemview.ItemRangeChangeEvent;
import org.teamapps.ux.component.infiniteitemview.ListInfiniteItemViewModel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;

public class InfiniteItemView2<RECORD>
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final Event<ItemClickedEventData<RECORD>> onItemClicked = new Event();
    private Template itemTemplate;
    private float itemWidth;
    private float itemHeight;
    private HorizontalElementAlignment itemContentHorizontalAlignment = HorizontalElementAlignment.STRETCH;
    private VerticalElementAlignment itemContentVerticalAlignment = VerticalElementAlignment.STRETCH;
    private int itemPositionAnimationTime = 200;
    private InfiniteItemViewModel<RECORD> model = new ListInfiniteItemViewModel(Collections.emptyList());
    private PropertyProvider<RECORD> itemPropertyProvider = new BeanPropertyExtractor();
    private ItemRange renderedRange = ItemRange.startEnd(0, 0);
    private RenderedRecordsCache<RECORD> renderedRecords = new RenderedRecordsCache();
    private int clientRecordIdCounter = 0;
    private Function<RECORD, Component> contextMenuProvider = null;
    private int lastSeenContextMenuRequestId;
    private int cachedModelCount = -1;
    private final Consumer<Void> modelOnAllDataChangedListener = aVoid -> this.refresh();
    private final Consumer<ItemRangeChangeEvent<RECORD>> modelOnRecordsAddedListener = this::handleModelRecordsAdded;
    private final Consumer<ItemRangeChangeEvent<RECORD>> modelOnRecordsChangedListener = this::handleModelRecordsChanged;
    private final Consumer<ItemRangeChangeEvent<RECORD>> modelOnRecordsDeletedListener = this::handleModelRecordsDeleted;

    public InfiniteItemView2(Template itemTemplate, float itemWidth, int itemHeight) {
        this.itemTemplate = itemTemplate;
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
    }

    public InfiniteItemView2(float itemWidth, int itemHeight) {
        this(BaseTemplate.ITEM_VIEW_ITEM, itemWidth, itemHeight);
    }

    public InfiniteItemView2() {
        this(BaseTemplate.ITEM_VIEW_ITEM, 300.0f, 300);
    }

    @Override
    public UiComponent createUiComponent() {
        UiInfiniteItemView2 ui = new UiInfiniteItemView2(this.itemTemplate.createUiTemplate());
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setItemWidth(this.itemWidth);
        ui.setItemHeight(this.itemHeight);
        ui.setItemContentHorizontalAlignment(this.itemContentHorizontalAlignment.toUiHorizontalElementAlignment());
        ui.setItemContentVerticalAlignment(this.itemContentVerticalAlignment.toUiVerticalElementAlignment());
        ui.setItemPositionAnimationTime((float)this.itemPositionAnimationTime);
        ui.setContextMenuEnabled(this.contextMenuProvider != null);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_INFINITE_ITEM_VIEW2_RENDERED_ITEM_RANGE_CHANGED: {
                UiInfiniteItemView2.RenderedItemRangeChangedEvent d = (UiInfiniteItemView2.RenderedItemRangeChangedEvent)event;
                this.handleScrollOrResize(ItemRange.startEnd(d.getStartIndex(), d.getEndIndex()));
                break;
            }
            case UI_INFINITE_ITEM_VIEW2_ITEM_CLICKED: {
                UiInfiniteItemView2.ItemClickedEvent e = (UiInfiniteItemView2.ItemClickedEvent)event;
                this.renderedRecords.getRecord(e.getRecordId()).ifPresent(record -> this.onItemClicked.fire(new ItemClickedEventData<Object>(record, e.getIsDoubleClick(), e.getIsRightMouseButton())));
                break;
            }
            case UI_INFINITE_ITEM_VIEW2_CONTEXT_MENU_REQUESTED: {
                UiInfiniteItemView2.ContextMenuRequestedEvent e = (UiInfiniteItemView2.ContextMenuRequestedEvent)event;
                this.lastSeenContextMenuRequestId = e.getRequestId();
                if (this.contextMenuProvider == null) {
                    this.closeContextMenu();
                    break;
                }
                this.renderedRecords.getRecord(e.getRecordId()).ifPresent(record -> {
                    Component contextMenuContent = this.contextMenuProvider.apply(record);
                    if (contextMenuContent != null) {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetContextMenuContentCommand(this.getId(), e.getRequestId(), contextMenuContent.createUiReference()));
                    } else {
                        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.CloseContextMenuCommand(this.getId(), e.getRequestId()));
                    }
                });
                break;
            }
        }
    }

    public InfiniteItemViewModel<RECORD> getModel() {
        return this.model;
    }

    public InfiniteItemView2<RECORD> setModel(InfiniteItemViewModel<RECORD> model) {
        this.unregisterModelListeners();
        this.model = model;
        this.refresh();
        model.onAllDataChanged().addListener(this.modelOnAllDataChangedListener);
        model.onRecordsAdded().addListener(this.modelOnRecordsAddedListener);
        model.onRecordsChanged().addListener(this.modelOnRecordsChangedListener);
        model.onRecordsDeleted().addListener(this.modelOnRecordsDeletedListener);
        return this;
    }

    private void unregisterModelListeners() {
        this.model.onAllDataChanged().removeListener(this.modelOnAllDataChangedListener);
        this.model.onRecordsAdded().removeListener(this.modelOnRecordsAddedListener);
        this.model.onRecordsChanged().removeListener(this.modelOnRecordsChangedListener);
        this.model.onRecordsDeleted().removeListener(this.modelOnRecordsDeletedListener);
    }

    public void refresh() {
        this.cachedModelCount = -1;
        this.sendFullRenderedRange();
    }

    private void sendFullRenderedRange() {
        if (!this.isRendered()) {
            return;
        }
        List<RECORD> records = this.retrieveRecords(this.renderedRange.getStart(), this.renderedRange.getLength());
        UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(records);
        this.renderedRecords = new RenderedRecordsCache(uiRecordMappingResult.recordAndClientRecords);
        this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
    }

    private void handleScrollOrResize(ItemRange newRange) {
        ItemRange oldRange = this.renderedRange;
        this.renderedRange = newRange;
        LOGGER.debug("new renderedRange: {}", (Object)newRange);
        if (newRange.overlaps(oldRange)) {
            boolean recordsAdded;
            UiRecordMappingResult<RECORD> uiRecordMappingResult;
            List<RECORD> records;
            ArrayList<UiIdentifiableClientRecord> newUiRecords = new ArrayList<UiIdentifiableClientRecord>();
            boolean recordsRemoved = false;
            if (newRange.getStart() < oldRange.getStart()) {
                records = this.retrieveRecords(newRange.getStart(), oldRange.getStart() - newRange.getStart());
                uiRecordMappingResult = this.mapToClientRecords(records);
                this.renderedRecords.insert(0, uiRecordMappingResult.recordAndClientRecords);
                LOGGER.debug("newRange.start < oldRange.start: {} < {} so adding {} uiRecords", new Object[]{newRange, oldRange, uiRecordMappingResult.newUiRecords.size()});
                newUiRecords.addAll(uiRecordMappingResult.newUiRecords);
            } else if (newRange.getStart() > oldRange.getStart()) {
                this.renderedRecords.remove(0, newRange.getStart() - oldRange.getStart());
                recordsRemoved = true;
            }
            if (newRange.getEnd() > oldRange.getEnd()) {
                records = this.retrieveRecords(oldRange.getEnd(), newRange.getEnd() - oldRange.getEnd());
                uiRecordMappingResult = this.mapToClientRecords(records);
                this.renderedRecords.insert(this.renderedRecords.size(), uiRecordMappingResult.recordAndClientRecords);
                newUiRecords.addAll(uiRecordMappingResult.newUiRecords);
            } else if (newRange.getEnd() < oldRange.getEnd() && newRange.getEnd() < this.getModelCount()) {
                int absoluteDeleteStartIndex = newRange.getEnd();
                int absoluteDeleteEndIndex = Math.min(oldRange.getEnd(), this.getModelCount());
                this.renderedRecords.remove(this.renderedRecords.size() - (absoluteDeleteEndIndex - absoluteDeleteStartIndex), this.renderedRecords.size());
                recordsRemoved = true;
            }
            boolean bl = recordsAdded = newUiRecords.size() > 0;
            if (recordsAdded || recordsRemoved) {
                this.updateClientRenderData(newUiRecords);
            }
        } else {
            LOGGER.debug("no overlap!");
            this.sendFullRenderedRange();
        }
        LOGGER.debug("renderedRange after scroll update: {}; renderedRecords.size: {}", (Object)this.renderedRange, (Object)this.renderedRecords.size());
    }

    private void handleModelRecordsAdded(ItemRangeChangeEvent<RECORD> changeEvent) {
        this.cachedModelCount += changeEvent.getLength();
        if (!this.isRendered()) {
            return;
        }
        if (changeEvent.getStart() < this.renderedRange.getEnd()) {
            int newRecordsStartIndex = Math.max(changeEvent.getStart(), this.renderedRange.getStart());
            int newRecordsLength = Math.min(changeEvent.getLength(), Math.min(this.renderedRange.getEnd() - changeEvent.getStart(), this.renderedRange.getLength()));
            int listInsertIndex = newRecordsStartIndex - this.renderedRange.getStart();
            List<RECORD> newRecords = this.retrieveRecords(newRecordsStartIndex, newRecordsLength);
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(newRecords);
            this.renderedRecords.insert(listInsertIndex, uiRecordMappingResult.recordAndClientRecords);
            if (this.renderedRange.getLength() < this.renderedRecords.size()) {
                this.renderedRecords.remove(this.renderedRange.getLength(), this.renderedRecords.size());
            }
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    private void handleModelRecordsChanged(ItemRangeChangeEvent<RECORD> changeEvent) {
        if (!this.isRendered()) {
            return;
        }
        if (changeEvent.getItemRange().overlaps(this.renderedRange)) {
            int queryStartIndex = Math.max(changeEvent.getStart(), this.renderedRange.getStart());
            int queryEndIndex = Math.min(changeEvent.getEnd(), this.renderedRange.getEnd());
            List changedRecords = changeEvent.getRecords().map(records -> records.subList(queryStartIndex - changeEvent.getStart(), queryEndIndex - changeEvent.getStart())).orElseGet(() -> this.retrieveRecords(queryStartIndex, queryEndIndex - queryStartIndex));
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(changedRecords);
            this.renderedRecords.remove(queryStartIndex - this.renderedRange.getStart(), queryEndIndex - this.renderedRange.getStart());
            this.renderedRecords.insert(queryStartIndex - this.renderedRange.getStart(), uiRecordMappingResult.recordAndClientRecords);
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    private void handleModelRecordsDeleted(ItemRangeChangeEvent<RECORD> changeEvent) {
        this.cachedModelCount -= changeEvent.getLength();
        if (!this.isRendered()) {
            return;
        }
        if (changeEvent.getStart() < this.renderedRange.getEnd()) {
            int removedRecordsStartIndex = Math.max(changeEvent.getStart(), this.renderedRange.getStart());
            int removedRecordsLength = Math.min(changeEvent.getLength(), Math.min(this.renderedRange.getEnd() - changeEvent.getStart(), this.renderedRange.getLength()));
            int removeIndexInsideList = removedRecordsStartIndex - this.renderedRange.getStart();
            List<RECORD> newRecords = this.retrieveRecords(this.renderedRange.getEnd(), removedRecordsLength);
            UiRecordMappingResult<RECORD> uiRecordMappingResult = this.mapToClientRecords(newRecords);
            this.renderedRecords.remove(removeIndexInsideList, removeIndexInsideList + removedRecordsLength);
            this.renderedRecords.insert(this.renderedRecords.size(), uiRecordMappingResult.recordAndClientRecords);
            this.updateClientRenderData(uiRecordMappingResult.newUiRecords);
        }
    }

    private int getModelCount() {
        if (this.cachedModelCount < 0) {
            this.cachedModelCount = this.model.getCount();
        }
        return this.cachedModelCount;
    }

    private List<RECORD> retrieveRecords(int startIndex, int length) {
        if (startIndex > this.getModelCount() || length <= 0) {
            return Collections.emptyList();
        }
        int actualStartIndex = Math.max(startIndex, 0);
        int actualLength = Math.min(this.getModelCount() - startIndex, length);
        return this.model.getRecords(actualStartIndex, actualLength);
    }

    private void updateClientRenderData(List<UiIdentifiableClientRecord> newUiRecords) {
        LOGGER.debug("newUiRecords: {}", (Object)newUiRecords.size());
        this.queueCommandIfRendered(() -> {
            LOGGER.debug("SENDING: renderedRange.start: {}; renderedRecords.size: {}; Count: {}", new Object[]{this.renderedRange.getStart(), this.renderedRecords.size(), this.getModelCount()});
            return new UiInfiniteItemView2.SetDataCommand(this.getId(), this.renderedRange.getStart(), this.renderedRecords.getUiRecordIds(), newUiRecords, this.getModelCount());
        });
    }

    private UiRecordMappingResult<RECORD> mapToClientRecords(List<RECORD> newRecords) {
        ArrayList<UiIdentifiableClientRecord> newUiRecords = new ArrayList<UiIdentifiableClientRecord>();
        ArrayList recordAndClientRecords = new ArrayList();
        for (RECORD r : newRecords) {
            boolean isNew;
            UiIdentifiableClientRecord existingUiRecord = this.renderedRecords.getUiRecord(r);
            UiIdentifiableClientRecord newUiRecord = this.createUiIdentifiableClientRecord(r);
            boolean bl = isNew = existingUiRecord == null || !existingUiRecord.getValues().equals(newUiRecord.getValues());
            if (isNew) {
                newUiRecords.add(newUiRecord);
            }
            recordAndClientRecords.add(new RecordAndClientRecord<RECORD>(r, isNew ? newUiRecord : existingUiRecord));
        }
        return new UiRecordMappingResult(recordAndClientRecords, newUiRecords);
    }

    private UiIdentifiableClientRecord createUiIdentifiableClientRecord(RECORD record) {
        UiIdentifiableClientRecord clientRecord = new UiIdentifiableClientRecord();
        clientRecord.setId(++this.clientRecordIdCounter);
        clientRecord.setValues(this.itemPropertyProvider.getValues(record, this.itemTemplate.getPropertyNames()));
        return clientRecord;
    }

    public Function<RECORD, Component> getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setContextMenuProvider(Function<RECORD, Component> contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    public void closeContextMenu() {
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.CloseContextMenuCommand(this.getId(), this.lastSeenContextMenuRequestId));
    }

    public Template getItemTemplate() {
        return this.itemTemplate;
    }

    public InfiniteItemView2<RECORD> setItemTemplate(Template itemTemplate) {
        this.itemTemplate = itemTemplate;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemTemplateCommand(this.getId(), itemTemplate.createUiTemplate()));
        return this;
    }

    public float getItemWidth() {
        return this.itemWidth;
    }

    public InfiniteItemView2<RECORD> setItemWidth(float itemWidth) {
        this.itemWidth = itemWidth;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemWidthCommand(this.getId(), itemWidth));
        return this;
    }

    public float getItemHeight() {
        return this.itemHeight;
    }

    public InfiniteItemView2<RECORD> setItemHeight(float itemHeight) {
        this.itemHeight = itemHeight;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemHeightCommand(this.getId(), itemHeight));
        return this;
    }

    public HorizontalElementAlignment getItemContentHorizontalAlignment() {
        return this.itemContentHorizontalAlignment;
    }

    public InfiniteItemView2<RECORD> setItemContentHorizontalAlignment(HorizontalElementAlignment itemContentHorizontalAlignment) {
        this.itemContentHorizontalAlignment = itemContentHorizontalAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemContentHorizontalAlignmentCommand(this.getId(), itemContentHorizontalAlignment.toUiHorizontalElementAlignment()));
        return this;
    }

    public VerticalElementAlignment getItemContentVerticalAlignment() {
        return this.itemContentVerticalAlignment;
    }

    public InfiniteItemView2<RECORD> setItemContentVerticalAlignment(VerticalElementAlignment itemContentVerticalAlignment) {
        this.itemContentVerticalAlignment = itemContentVerticalAlignment;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemContentVerticalAlignmentCommand(this.getId(), itemContentVerticalAlignment.toUiVerticalElementAlignment()));
        return this;
    }

    public int getItemPositionAnimationTime() {
        return this.itemPositionAnimationTime;
    }

    public void setItemPositionAnimationTime(int itemPositionAnimationTime) {
        this.itemPositionAnimationTime = itemPositionAnimationTime;
        this.queueCommandIfRendered(() -> new UiInfiniteItemView2.SetItemPositionAnimationTimeCommand(this.getId(), itemPositionAnimationTime));
    }

    public PropertyProvider<RECORD> getItemPropertyProvider() {
        return this.itemPropertyProvider;
    }

    public void setItemPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.itemPropertyProvider = propertyProvider;
    }

    public void setItemPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setItemPropertyProvider(propertyExtractor);
    }

    private static class UiRecordMappingResult<RECORD> {
        List<RecordAndClientRecord<RECORD>> recordAndClientRecords;
        List<UiIdentifiableClientRecord> newUiRecords;

        public UiRecordMappingResult(List<RecordAndClientRecord<RECORD>> recordAndClientRecords, List<UiIdentifiableClientRecord> newUiRecords) {
            this.recordAndClientRecords = recordAndClientRecords;
            this.newUiRecords = newUiRecords;
        }
    }

    private static class RenderedRecordsCache<RECORD> {
        private final Map<RECORD, UiIdentifiableClientRecord> uiRecordsByRecord = new HashMap<RECORD, UiIdentifiableClientRecord>();
        private final List<RecordAndClientRecord<RECORD>> recordPairs = new ArrayList<RecordAndClientRecord<RECORD>>();

        public RenderedRecordsCache() {
        }

        public RenderedRecordsCache(List<RecordAndClientRecord<RECORD>> recordPairs) {
            this.insert(0, recordPairs);
        }

        UiIdentifiableClientRecord getUiRecord(RECORD record) {
            return this.uiRecordsByRecord.get(record);
        }

        Optional<RECORD> getRecord(int uiRecordId) {
            return this.recordPairs.stream().filter(rr -> rr.uiRecord.getId() == uiRecordId).map(rr -> rr.record).findFirst();
        }

        List<Integer> getUiRecordIds() {
            return this.recordPairs.stream().map(rr -> rr.uiRecord.getId()).collect(Collectors.toList());
        }

        void insert(int listInsertIndex, List<RecordAndClientRecord<RECORD>> newClientRecordPairs) {
            this.recordPairs.addAll(listInsertIndex, newClientRecordPairs);
            for (RecordAndClientRecord<RECORD> rr : newClientRecordPairs) {
                this.uiRecordsByRecord.put(rr.record, rr.uiRecord);
            }
        }

        void remove(int startIndex, int endIndex) {
            List<RecordAndClientRecord<RECORD>> recordsToBeRemoved = this.recordPairs.subList(startIndex, endIndex);
            for (RecordAndClientRecord<RECORD> rr : recordsToBeRemoved) {
                this.uiRecordsByRecord.remove(rr.record);
            }
            recordsToBeRemoved.clear();
        }

        int size() {
            return this.recordPairs.size();
        }
    }

    private static class RecordAndClientRecord<RECORD> {
        final RECORD record;
        final UiIdentifiableClientRecord uiRecord;

        public RecordAndClientRecord(RECORD record, UiIdentifiableClientRecord uiRecord) {
            this.record = record;
            this.uiRecord = uiRecord;
        }
    }
}

