/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.qrscanner;

import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiQrCodeScanner;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;

public class QrCodeScanner
extends AbstractComponent {
    public final Event<String> onQrCodeDetected = new Event();
    private boolean scanning;
    private boolean stopsScanningAtFirstResult;

    @Override
    public UiComponent createUiComponent() {
        UiQrCodeScanner ui = new UiQrCodeScanner();
        this.mapAbstractUiComponentProperties((UiComponent)ui);
        ui.setScanning(this.scanning);
        ui.setStopsScanningAtFirstResult(this.stopsScanningAtFirstResult);
        return ui;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_QR_CODE_SCANNER_QR_CODE_DETECTED: {
                this.onQrCodeDetected.fire(((UiQrCodeScanner.QrCodeDetectedEvent)event).getCode());
            }
        }
    }

    public void startScanning(boolean stopScanningAtFirstResult) {
        this.scanning = true;
        this.stopsScanningAtFirstResult = stopScanningAtFirstResult;
        this.queueCommandIfRendered(() -> new UiQrCodeScanner.StartScanningCommand(this.getId(), stopScanningAtFirstResult));
    }

    public void stopScanning() {
        this.scanning = false;
        this.queueCommandIfRendered(() -> new UiQrCodeScanner.StopScanningCommand(this.getId()));
    }

    public void switchCamera() {
        this.queueCommandIfRendered(() -> new UiQrCodeScanner.SwitchCameraCommand(this.getId()));
    }
}

