/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.datapoints;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.teamapps.dto.UiGraphData;
import org.teamapps.dto.UiIncidentGraphData;
import org.teamapps.dto.UiIncidentGraphDataPoint;
import org.teamapps.ux.component.timegraph.datapoints.GraphData;
import org.teamapps.ux.component.timegraph.datapoints.IncidentGraphDataPoint;

public interface IncidentGraphData
extends GraphData {
    public int size();

    public IncidentGraphDataPoint getDataPoint(int var1);

    default public Stream<IncidentGraphDataPoint> streamDataPoints() {
        int[] i = new int[]{0};
        return Stream.generate(() -> {
            int n = i[0];
            i[0] = n + 1;
            return this.getDataPoint(n);
        }).limit(this.size());
    }

    @Override
    default public UiGraphData toUiGraphData() {
        return new UiIncidentGraphData(this.streamDataPoints().map(d -> new UiIncidentGraphDataPoint(d.getX1(), d.getX2(), d.getY(), d.getColor().toHtmlColorString(), d.getTooltipHtml())).collect(Collectors.toList()), this.getInterval().toUiLongInterval());
    }
}

