/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.data.extract;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.ClassAndPropertyName;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.util.ReflectionUtil;

public class BeanPropertyExtractor<RECORD>
implements PropertyExtractor<RECORD> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanPropertyExtractor.class);
    private static final Map<ClassAndPropertyName, ValueExtractor> valueExtractorsByClassAndPropertyName = new ConcurrentHashMap<ClassAndPropertyName, ValueExtractor>();
    private final Map<String, ValueExtractor<RECORD, ?>> customExtractors = new HashMap(0);
    private final boolean fallbackToFields;

    public BeanPropertyExtractor() {
        this(false);
    }

    public BeanPropertyExtractor(boolean fallbackToFields) {
        this.fallbackToFields = fallbackToFields;
    }

    @Override
    public Object getValue(RECORD record, String propertyName) {
        ValueExtractor<RECORD, ?> valueExtractor = this.getValueExtractor(record.getClass(), propertyName);
        return valueExtractor.extract(record);
    }

    protected ValueExtractor<RECORD, ?> getValueExtractor(Class clazz, String propertyName) {
        ValueExtractor<RECORD, ?> valueExtractor = this.customExtractors.get(propertyName);
        if (valueExtractor != null) {
            return valueExtractor;
        }
        return valueExtractorsByClassAndPropertyName.computeIfAbsent(new ClassAndPropertyName(clazz, propertyName, this.fallbackToFields), classAndPropertyName -> this.createValueExtractor((ClassAndPropertyName)classAndPropertyName));
    }

    private ValueExtractor<RECORD, ?> createValueExtractor(ClassAndPropertyName classAndPropertyName) {
        Field field;
        Method getter = ReflectionUtil.findGetter(classAndPropertyName.clazz, classAndPropertyName.propertyName);
        if (getter != null) {
            return record -> ReflectionUtil.invokeMethod(record, getter, new Object[0]);
        }
        if (this.fallbackToFields && (field = ReflectionUtil.findField(classAndPropertyName.clazz, classAndPropertyName.propertyName)) != null) {
            return record -> ReflectionUtil.readField(record, field, true);
        }
        LOGGER.debug("Could not find getter " + (this.fallbackToFields ? "or field " : "") + "for property {} on class {}!", (Object)classAndPropertyName.propertyName, (Object)classAndPropertyName.getClass().getCanonicalName());
        return record -> null;
    }

    public BeanPropertyExtractor<RECORD> addProperty(String propertyName, ValueExtractor<RECORD, ?> valueExtractor) {
        this.customExtractors.put(propertyName, valueExtractor);
        return this;
    }
}

