/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.core.TeamAppsUploadManager;
import org.teamapps.core.TeamAppsUxSessionManager;
import org.teamapps.icons.IconLibraryRegistry;
import org.teamapps.icons.IconProvider;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.uisession.TeamAppsUiSessionManager;
import org.teamapps.util.threading.SequentialExecutorFactory;
import org.teamapps.webcontroller.WebController;

public class TeamAppsCore {
    private final TeamAppsConfiguration config;
    private final WebController webController;
    private final ObjectMapper objectMapper;
    private final TeamAppsUiSessionManager uiSessionManager;
    private final IconLibraryRegistry iconLibraryRegistry;
    private final TeamAppsUxSessionManager sessionManager;
    private final TeamAppsUploadManager uploadManager;
    private final IconProvider iconProvider;

    public TeamAppsCore(TeamAppsConfiguration config, SequentialExecutorFactory sessionExecutorFactory, WebController webController) {
        this.config = config;
        this.webController = webController;
        this.objectMapper = TeamAppsObjectMapperFactory.create();
        this.iconLibraryRegistry = new IconLibraryRegistry();
        this.uploadManager = new TeamAppsUploadManager();
        this.uiSessionManager = new TeamAppsUiSessionManager(config, this.objectMapper);
        this.iconProvider = new IconProvider(this.iconLibraryRegistry);
        this.sessionManager = new TeamAppsUxSessionManager(sessionExecutorFactory, webController, this.uiSessionManager, this.iconProvider, this.uploadManager);
        this.uiSessionManager.setUiSessionListener(this.sessionManager);
    }

    public TeamAppsConfiguration getConfig() {
        return this.config;
    }

    public WebController getWebController() {
        return this.webController;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public TeamAppsUiSessionManager getUiSessionManager() {
        return this.uiSessionManager;
    }

    public IconLibraryRegistry getIconLibraryRegistry() {
        return this.iconLibraryRegistry;
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public TeamAppsUxSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public TeamAppsUploadManager getUploadManager() {
        return this.uploadManager;
    }
}

