/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.teamapps.dto.UiCommand;

public class SessionRecorder {
    private final ObjectMapper jacksonObjectMapper;
    private final Writer writer;

    public SessionRecorder(ObjectMapper jacksonObjectMapper, OutputStream outputStream) {
        this.jacksonObjectMapper = jacksonObjectMapper;
        this.writer = new OutputStreamWriter(outputStream);
    }

    public void recordCommands(List<UiCommand> uiCommands) {
        try {
            for (UiCommand command : uiCommands) {
                String commandAsString = this.jacksonObjectMapper.writeValueAsString((Object)command);
                this.writer.write(commandAsString);
                this.writer.write("\n");
                this.writer.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

